@ECHO off
: DOWNLOAD.BAT - Across-The-Wire Migration Download Batch File (DOS)
:
: "CoPyRiGhT=(c) 1994 Novell, Inc.  All Rights Reserved."
:  VeRsIoN=4.10

IF "%1" == "" GOTO ERROR
SET SRC=%1

SET SRCGOOD=FALSE
FOR %%F IN (D: E: F: G: H: I: J: K: L: M: N: O: P: Q: R: S: T: U: V: W: X: Y: Z:) DO IF "%%F" == "%SRC%" SET SRCGOOD=TRUE
FOR %%F IN (d: e: f: g: h: i: j: k: l: m: n: o: p: q: r: s: t: u: v: w: x: y: z:) DO IF "%%F" == "%SRC%" SET SRCGOOD=TRUE
IF "%SRCGOOD%" == "TRUE" GOTO CHKHDFIL
ECHO 
ECHO The source drive (%SRC%) is invalid.
ECHO You may only specify a drive letter followed by a colon,
ECHO and the specified drive may not be a floppy drive.
ECHO.
GOTO CLEANUP


:CHKHDFIL
IF NOT EXIST %SRC%MIGRATE.EXE GOTO ERROR

SET DEST=C:\MIGRATE
IF NOT "%2" == "" SET DEST=%2
XCOPY DOWNLOAD.BAT %DEST%\*.* > NUL
IF ERRORLEVEL 0 GOTO SETLANG
ECHO 
ECHO Cannot create the destination directory (%DEST%).
ECHO You must create it before continuing.
ECHO.
GOTO CLEANUP

:SETLANG
DEL %DEST%\DOWNLOAD.BAT > NUL
IF NOT "%NWLANGUAGE%" == "" GOTO TESTLANG
ECHO 
ECHO Your NWLANGUAGE environment variable was not set.  It will be set
ECHO to ENGLISH, and English message files will be downloaded.
PAUSE
SET NWLANGUAGE=ENGLISH

:TESTLANG
IF "%NWLANGUAGE%" == "English"   GOTO COPYFILES
IF "%NWLANGUAGE%" == "ENGLISH"   GOTO COPYFILES
IF "%NWLANGUAGE%" == "english"   GOTO COPYFILES

IF "%NWLANGUAGE%" == "Francais"  GOTO COPYFILES
IF "%NWLANGUAGE%" == "FRANCAIS"  GOTO COPYFILES
IF "%NWLANGUAGE%" == "francais"  GOTO COPYFILES

IF "%NWLANGUAGE%" == "Italiano"  GOTO COPYFILES
IF "%NWLANGUAGE%" == "ITALIANO"  GOTO COPYFILES
IF "%NWLANGUAGE%" == "italiano"  GOTO COPYFILES

IF "%NWLANGUAGE%" == "Deutsch"   GOTO COPYFILES
IF "%NWLANGUAGE%" == "DEUTSCH"   GOTO COPYFILES
IF "%NWLANGUAGE%" == "deutsch"   GOTO COPYFILES

IF "%NWLANGUAGE%" == "Espanol"   GOTO COPYFILES
IF "%NWLANGUAGE%" == "ESPANOL"   GOTO COPYFILES
IF "%NWLANGUAGE%" == "espanol"   GOTO COPYFILES

IF "%NWLANGUAGE%" == "Portugue"  GOTO COPYFILES
IF "%NWLANGUAGE%" == "PORTUGUE"  GOTO COPYFILES
IF "%NWLANGUAGE%" == "portugue"  GOTO COPYFILES

ECHO 
ECHO Your NWLANGUAGE environment variable (%NWLANGUAGE%) was not
ECHO recognized.  It will be set to ENGLISH, and English message
ECHO files will be downloaded.
PAUSE
SET NWLANGUAGE=ENGLISH

:COPYFILES
ECHO.
ECHO Downloading files from %SRC% to %DEST%
ECHO ---------------------------------------------------------
ECHO.
XCOPY %SRC%.\*.* %DEST%.\*.*
ECHO.
ECHO Downloading files from %SRC%NLS\%NWLANGUAGE% to %DEST%\NLS\%NWLANGUAGE%
ECHO ---------------------------------------------------------
ECHO.
XCOPY %SRC%.\NLS\%NWLANGUAGE%\*.* %DEST%.\NLS\%NWLANGUAGE%\*.*
ECHO.
ECHO Migration files were successfully downloaded ------------
ECHO.
GOTO CLEANUP

:ERROR
ECHO.
ECHO Usage: DOWNLOAD src_drive: [dst_path]
ECHO 
ECHO    src_drive:            = D:-Z: (colon required).  Specify only a
ECHO                            letter followed by a colon.  The current
ECHO                            working directory must contain MIGRATE.EXE.
ECHO.
ECHO    dst_path              = If not specified, defaults to C:\MIGRATE.
ECHO.
ECHO Examples:
ECHO.
ECHO    DOWNLOAD E:             Invoked from a CD-ROM drive or a network
ECHO                            drive, installs from drive E: to
ECHO                            C:\MIGRATE.
ECHO.
ECHO    DOWNLOAD E: C:\TEMP     Invoked from a CD-ROM drive or a network
ECHO                            drive, installs from drive E: to C:\TEMP.
ECHO.

:CLEANUP
SET SRC=
SET DEST=
SET HARDDISK=
SET SRCGOOD=
