'[PROCEDURE]
'Purpose - Displays a heading containing server and application information.
'[PARAM1]
'Purpose - A 35 character string (Extra chars. are truncated)
'Type    - String
'Default - "" ( NULL string)
'[RETURN]
'Purpose - Returns NULL
'Type    - String
'[EXAMPLE]
'Message = "This is your application."
'RPC:Call("","HEADING.BAS",Message)
'SYS:Delay(2000)
'WIN:Heading:Off

Local("ConNumberObject","ConNumber","ConObject","Heading","Msg")

Msg = Param(1,"")
ConNumberObject = NET:Connection:Get()
If (ConNumberObject.Error != 0)
   Heading = "User On File Server " + NET:Server:Name() + " Connection " + DATA:String(ConNumber)
   Heading = STR:Sub(Heading,1,78)
Else
   ConNumber = DATA:Integer(ConNumberObject.Number)
   ConObject = NET:Connection:Info(ConNumber)
   If (ConObject.Error != 0)
      Heading = "User On File Server " + NET:Server:Name() + " Connection " + DATA:String(ConNumber)
      Heading = STR:Sub(Heading,1,78)
   Else
      Heading = "User " + ConObject.Name + " On File Server " + NET:Server:Name() + " Connection " + DATA:String(ConNumber)
      Heading = STR:Sub(Heading,1,78)
   EndIf
EndIf

WIN:Heading:On(Msg,Heading)

Return

