' (C) Copyright 1993-1996 HITECSOFT CORP. All rights reserved.
'----------------------------------------------------------------------
' This Pogram changes the current directory
' Format: DIR [Path]
' PATH = Directory to change to
'----------------------------------------------------------------------

Sub main
'----------------------------------------------------------------------
' if there is no parameter just print the current directory
'----------------------------------------------------------------------

If (SYS:Param:Count = 1)
   NewLine
   DirO = DIR:Path:Get()
   Print(DirO.Volume.Name,DirO.Path)
   NewLine
   Return
EndIf

'-------------------------------------------------------------------------
' see if there is a : in the parameter -- if so look it up in the Environment
' for single letter drive such as X:, we check the 2nd string position for a :
'-------------------------------------------------------------------------

If (STR:Sub(SYS:Param(2),2) = ":")
   '----------------------------------------------------------------------
   ' Get the string that has a : in it
   '----------------------------------------------------------------------
   Vol = STR:Upper(SYS:Param(2))
   Vol = STR:Sub(Vol,1)
   '----------------------------------------------------------------------
   ' look it up in the Environment
   '----------------------------------------------------------------------
   EnvO = ENV:Get(Vol)
   if (EnvO.error=0) ; 'if we found it
      '----------------------------------------------------------------------
      ' Parse var into its directory components
      '----------------------------------------------------------------------
      DirO = DIR:Object(EnvO.string)
      
      '----------------------------------------------------------------------
      ' Get Current Directory Information
      '----------------------------------------------------------------------
      CurrentDirO = DIR:Path:Get()
      
      '----------------------------------------------------------------------
      ' Get Current Directory Information
      '----------------------------------------------------------------------
      CurrentDirO.Path = DirO.Path
      
      '----------------------------------------------------------------------
      ' Set the information in the object
      '----------------------------------------------------------------------
      CurrentDirO.Volume.Name = DirO.Volume.Name
      CurrentDirO.Server.Name = DirO.Server.Name
      
      '----------------------------------------------------------------------
      ' Let Object Manager manage it
      '----------------------------------------------------------------------
      CurrentDirO = DIR:Path:Set(CurrentDirO)
      If (CurrentDirO.error != 0)
         Print("Directory ",EnvO.string," not found!")
         NewLine
      EndIf
   Else
      NewLine
      Print(Vol," Drive not found!")
      NewLine
   EndIf
Else
   '----------------------------------------------------------------------
   ' Get Current Directory Information
   '----------------------------------------------------------------------
   CurrentDirO = DIR:Path:Get()
   temp = SYS:Param(2)
   If temp != "\"
      temp = temp + "\"
   EndIf
   
   '----------------------------------------------------------------------
   ' Parse var into its directory components
   '----------------------------------------------------------------------
   DirO = DIR:Object(temp)
   
   '----------------------------------------------------------------------
   ' Set the information in the object
   '----------------------------------------------------------------------
   CurrentDirO.Volume.Name = DirO.Volume.Name
   CurrentDirO.Path = DirO.Path
   
   '----------------------------------------------------------------------
   ' Let Object Manager manage it
   '----------------------------------------------------------------------
   CurrentDirO = DIR:Path:Set(CurrentDirO)
   If (CurrentDirO.error != 0)
      Print("Directory [",SYS:Param(2),"] not found!")
      NewLine
   EndIf
EndIf

End Sub
