'(C) Copyright 1993-1996 HITECSOFT CORP. All rights reserved.
#include "BASIC.H"
#include "KEY.H"
#include "NET.H"
#include "WIN.H"

Sub BuildMainMenu
Local("Window")

Window = WIN:Menu:Define(10,28)
WIN:Title(" Main Menu ")

WIN:Menu:Item:Add("Change Time Interval  ")
WIN:Menu:Item:Add("Start Monitoring      ")
WIN:Menu:Item:Add("Exit                  ")

Return(Window)

End Sub
Sub DisplayCPUWork
Local("Window","Util1","Util2")

Window = Param(1,"")
If (DATA:Type("Window") != "I")
   Return(False)
EndIf

WIN:Select(Window)
Util1 = NET:Stat:Server:Utilization()
Util2 = Util1
If (Util2 = 0)
   Util2 = 1
EndIf

Util2 = STR:Repeat("",DATA:Integer(Util2 * 0.70))

WIN:Say(DATA:Char(10),Util2," ",Util1)

Return(True)

End Sub
Sub DisplayServerWork
Local("Window","SzBuf")

Window = Param(1,"")
If (DATA:Type("Window") != "I")
   Return(False)
EndIf

WIN:Select(Window)
WIN:Cursor:Hide

If (FirstTimeZZ = True)
   FirstTimeZZ = False
   
   OldStatDataZZ(1) = NET:Stat:File:Opens()
   OldStatDataZZ(2) = NET:Stat:File:Creates()
   OldStatDataZZ(3) = NET:Stat:File:Deletes()
   OldStatDataZZ(4) = NET:Stat:Directory:Searches()
   OldStatDataZZ(5) = NET:Stat:File:Reads()
   OldStatDataZZ(6) = NET:Stat:File:Writes()
   OldStatDataZZ(7) = NET:Stat:Record:Locks()
   OldStatDataZZ(8) = NET:Stat:Transactions()
   OldStatDataZZ(9) = NET:Stat:Disk:Reads()
   OldStatDataZZ(10) = NET:Stat:Disk:Writes()
   OldStatDataZZ(11) = NET:Stat:Packets:Received()
   OldStatDataZZ(12) = NET:Stat:Packets:Transmitted()
   
   SzBuf = 0
   
   WIN:At(1,23)
   WIN:Say(SzBuf)
   WIN:At(2,23)
   WIN:Say(SzBuf)
   WIN:At(3,23)
   WIN:Say(SzBuf)
   WIN:At(4,23)
   WIN:Say(SzBuf)
   WIN:At(5,23)
   WIN:Say(SzBuf)
   WIN:At(6,23)
   WIN:Say(SzBuf)
   
   WIN:At(1,61)
   WIN:Say(SzBuf)
   WIN:At(2,61)
   WIN:Say(SzBuf)
   WIN:At(3,61)
   WIN:Say(SzBuf)
   WIN:At(4,61)
   WIN:Say(SzBuf)
   WIN:At(5,61)
   WIN:Say(SzBuf)
   WIN:At(6,61)
   WIN:Say(SzBuf)
   
   Return(True)
EndIf

NewStatDataZZ(1) = NET:Stat:File:Opens()
NewStatDataZZ(2) = NET:Stat:File:Creates()
NewStatDataZZ(3) = NET:Stat:File:Deletes()
NewStatDataZZ(4) = NET:Stat:Directory:Searches()
NewStatDataZZ(5) = NET:Stat:File:Reads()
NewStatDataZZ(6) = NET:Stat:File:Writes()
NewStatDataZZ(7) = NET:Stat:Record:Locks()
NewStatDataZZ(8) = NET:Stat:Transactions()
NewStatDataZZ(9) = NET:Stat:Disk:Reads()
NewStatDataZZ(10) = NET:Stat:Disk:Writes()
NewStatDataZZ(11) = NET:Stat:Packets:Received()
NewStatDataZZ(12) = NET:Stat:Packets:Transmitted()

SzBuf = STR:Repeat(" ",10)

WIN:At(1,23)
WIN:Say(SzBuf)
WIN:At(1,23)
WIN:Say(MATH:Abs(NewStatDataZZ(1) - OldStatDataZZ(1)))
WIN:At(2,23)
WIN:Say(SzBuf)
WIN:At(2,23)
WIN:Say(MATH:Abs(NewStatDataZZ(2) - OldStatDataZZ(2)))
WIN:At(3,23)
WIN:Say(SzBuf)
WIN:At(3,23)
WIN:Say(MATH:Abs(NewStatDataZZ(3) - OldStatDataZZ(3)))
WIN:At(4,23)
WIN:Say(SzBuf)
WIN:At(4,23)
WIN:Say(MATH:Abs(NewStatDataZZ(4) - OldStatDataZZ(4)))
WIN:At(5,23)
WIN:Say(SzBuf)
WIN:At(5,23)
WIN:Say(MATH:Abs(NewStatDataZZ(5) - OldStatDataZZ(5)))
WIN:At(6,23)
WIN:Say(SzBuf)
WIN:At(6,23)
WIN:Say(MATH:Abs(NewStatDataZZ(6) - OldStatDataZZ(6)))

WIN:At(1,61)
WIN:Say(SzBuf)
WIN:At(1,61)
WIN:Say(MATH:Abs(NewStatDataZZ(7) - OldStatDataZZ(7)))
WIN:At(2,61)
WIN:Say(SzBuf)
WIN:At(2,61)
WIN:Say(MATH:Abs(NewStatDataZZ(8) - OldStatDataZZ(8)))
WIN:At(3,61)
WIN:Say(SzBuf)
WIN:At(3,61)
WIN:Say(MATH:Abs(NewStatDataZZ(9) - OldStatDataZZ(9)))
WIN:At(4,61)
WIN:Say(SzBuf)
WIN:At(4,61)
WIN:Say(MATH:Abs(NewStatDataZZ(10) - OldStatDataZZ(10)))
WIN:At(5,61)
WIN:Say(SzBuf)
WIN:At(5,61)
WIN:Say(MATH:Abs(NewStatDataZZ(11) - OldStatDataZZ(11)))
WIN:At(6,61)
WIN:Say(SzBuf)
WIN:At(6,61)
WIN:Say(MATH:Abs(NewStatDataZZ(12) - OldStatDataZZ(12)))

OldStatDataZZ(1) = NewStatDataZZ(1)
OldStatDataZZ(2) = NewStatDataZZ(2)
OldStatDataZZ(3) = NewStatDataZZ(3)
OldStatDataZZ(4) = NewStatDataZZ(4)
OldStatDataZZ(5) = NewStatDataZZ(5)
OldStatDataZZ(6) = NewStatDataZZ(6)
OldStatDataZZ(7) = NewStatDataZZ(7)
OldStatDataZZ(8) = NewStatDataZZ(8)
OldStatDataZZ(9) = NewStatDataZZ(9)
OldStatDataZZ(10) = NewStatDataZZ(10)
OldStatDataZZ(11) = NewStatDataZZ(11)
OldStatDataZZ(12) = NewStatDataZZ(12)

End Sub
Sub Main

Local("Window1","Window2","Window3")
Local("SzBuf","I")

RPC:Call("","HEADING.BAS","HiTecSoft Server Monitor")

TimeGapZZ = 3

Window1 = BuildMainMenu

Window2 = WIN:Define(6,2,14,79)
WIN:Title(" CPU Percentage Utilization ")
WIN:Show
WIN:Clear
WIN:At(1,1)

Window3 = WIN:Define(16,2,23,79)
SzBuf = " Server Miscellaneous Information per Time Interval "
WIN:Title(SzBuf)
WIN:Show
WIN:Clear

WIN:At(1,2)
WIN:Say("File Opens")
WIN:At(2,2)
WIN:Say("File Creates")
WIN:At(3,2)
WIN:Say("File Deletes")
WIN:At(4,2)
WIN:Say("Directory Searches")
WIN:At(5,2)
WIN:Say("File Reads")
WIN:At(6,2)
WIN:Say("File Writes")

WIN:At(1,40)
WIN:Say("Record Locks")
WIN:At(2,40)
WIN:Say("Transactions")
WIN:At(3,40)
WIN:Say("Disk Reads")
WIN:At(4,40)
WIN:Say("Disk Writes")
WIN:At(5,40)
WIN:Say("Packets Received")
WIN:At(6,40)
WIN:Say("Packets Transmitted")

WIN:Select(0)
WIN:At(25,4)
SzBuf = "Press Any Key for Main Menu    Press <ESCAPE> to Exit    "
SzBuf = SzBuf + "Time Interval: " + STR:Pad:Right(DATA:String(TimeGapZZ),2)
WIN:Say(SzBuf)

FirstTimeZZ = True

I = TimeGapZZ
Do While (True)
   If (I = TimeGapZZ)
      DisplayCPUWork(Window2)
      DisplayServerWork(Window3)
      
      I = 0
   EndIf
   
   If (KEY:Ready)
      KEY:Read
      If (KEY:Last = KEY_ESC)
         If (RPC:Call("","YESNO.BAS"," Exit NetWStat ? "))
            Exit
         EndIf
      Else
         If (RunMainMenu(Window1) = True)
            Exit
         Else
            I = TimeGapZZ
            Loop
         EndIf
      EndIf
      
   EndIf
   
   SYS:Delay(1000)
   I = I + 1
EndDo

WIN:Close(Window2)
WIN:Close(Window3)

WIN:Heading:Off
WIN:Cursor:Show

End Sub

Sub RunMainMenu
Local("Window","Choice","Obj","SzBuf")

Window = Param(1,"")
If (DATA:Type("Window") != "I")
   Return(True)
EndIf

WIN:Select(Window)

Do While (True)
   Choice = WIN:Menu:Start(1)
   
   If (Choice = 1)
      Obj = RPC:Call("","GETSTRNG.BAS","Time Interval (2 to 10):",4,3,1,15,26,DATA:String(TimeGapZZ),1)
      If (Obj.Error = 0)
         SzBuf = DATA:Integer(Obj.String)
         If ((SzBuf >= 2) & (SzBuf <= 10))
            TimeGapZZ = SzBuf
            
            WIN:Select(0)
            WIN:At(25,76)
            SzBuf = STR:Pad:Right(DATA:String(TimeGapZZ),2)
            WIN:Say(SzBuf)
         EndIf
      EndIf
      
      Exit
   EndIf
   
   If (Choice = 2)
      Exit
   EndIf
   
   If (Choice = 3)
      If (RPC:Call("","YESNO.BAS"," Exit NetWStat ? "))
         WIN:Close(Window)
         Return(True)
      EndIf
   EndIf
EndDo

WIN:Hide(Window)

Return(False)

End Sub
