'(C) Copyright 1993-1996 HITECSOFT CORP. All rights reserved.
#include "sys.H"
#include "win.H"
#include "key.H"
#include "net.H"

Sub BuildMainMenu
Local("Menu")
Menu = WIN:Menu:Define(20,30)
WIN:Title(" Main Menu ")
WIN:Menu:Item:Add("Change Server   ")
WIN:Menu:Item:Add("Change Check Interval ")
WIN:Menu:Item:Add("Start Monitoring")
WIN:Menu:Item:Add("Exit            ")
Return(Menu)

End Sub
Sub BuildMainWindow
Local("Window")
MainTitle = "Volume Information V1.0"
RPC:Call("","HEADING.BAS",MainTitle)
Window = WIN:Define(6,4,17,77)
WIN:Title(" Press any key for Menu - Esc will Exit ")
WIN:Show
Return(Window)

End Sub
Sub ChangeDelay
WIN:Define(16,25,18,55)
WIN:Show()
WIN:At(1,1); WIN:Say("Enter Delay Value : ")
WIN:Get(DelayTime)
WIN:Get:Read()
WIN:Close()

End Sub
Sub ChecKDelay
Local("i")

i = 0
Do While (i < Param(1))
   If (KEY:Ready)
      Return
   EndIf
   SYS:Delay(1000)
   i = i + 1
EndDo

End Sub
Sub DoChangeServer
Local("SelectionObject","serverName","con","ConnInfoObject")

SelectionObject = RPC:Call("","SERVPICK.BAS")

If (SelectionObject.Error != 0)
   WIN:Popup("No Server was found!")
   Return
EndIf

If (DATA:Integer(SelectionObject.Key) != KEY_ENTER)
   WIN:Popup("No Server was selected!")
   Return
EndIf

ServerName = SelectionObject.item
Con = DATA:Integer(SelectionObject.Number)
ConnInfoObject = NET:Connection:Get()
ConnInfoObject.ID = Con
ConnInfoObject = NET:Connection:Set(ConnInfoObject)

If (ConnInfoObject.Error != 0)
   WIN:Popup("Error changing Server!")
   Return
EndIf
RPC:Call("","HEADING.BAS",MainTitle)

End Sub
Sub Main

'Initialize vars.
Choice = 3
DelayTime = 5
VolNumber = 3
VolumeRate = 1
VolumeRateUsage = 0
SaveVolUsed(1) = 0
SaveVolUsed(2) = 0
SaveVolUsed(3) = 0
SampTime(1) = DATE:Utf()
SampTime(2) = DATE:Utf()
SampTime(3) = DATE:Utf()
SampDiff(1) = DelayTime
SampDiff(2) = DelayTime
SampDiff(3) = DelayTime

WIN:Cursor:Hide

MainWindow = BuildMainWindow

MainMenu = BuildMainMenu

Do While (True)
   UpdateWindow(MainWindow,VolNumber)
   CheckDelay(DelayTime)
   If (KEY:Ready)
      KEY:Read
      If (KEY:Last = KEY_ESC)
         If (YesNo("Exit Volinfo ?"))
            WIN:Close(MainMenu)
            WIN:Close(MainWindow)
            WIN:Heading:Off
            WIN:Clear
            WIN:Cursor:Show
            Quit
         EndIf
      Else
         choice = ProcessMainMenu(choice)
      EndIf
   EndIf
EndDo

End Sub
Sub ProcessMainMenu
Local("choice")

WIN:Select(MainMenu)
choice = WIN:Menu:Start(Param(1))
If (KEY:Last() = KEY_RETURN)
   If (choice = 1)
      DoChangeServer
      WIN:Select(MainWindow)
      WIN:Clear
      WIN:Select(MainMenu)
   EndIf
   If (choice = 2)
      ChangeDelay
   EndIf
   If (choice = 3)
   EndIf
   If (choice = 4)
      If (YesNo("Exit Volinfo ?"))
         WIN:Close(MainMenu)
         WIN:Close(MainWindow)
         WIN:Heading:Off
         WIN:Clear
         WIN:Cursor:Show
         Quit
      EndIf
   EndIf
EndIf
WIN:Hide(MainMenu)

Return(choice)
End Sub
Sub UpdateVolumeInfo
Local("VolO","VolumeNumber","Total","Used","DeletedUsed","Free","UsedDir","Col","Row","VolUsed")
Local("Blank")

VolumeNumber = Param(2)
VolO = NET:Volume:Info(VolumeNumber)
If (VolO.Error != 0)
   Return
EndIf
Total = DATA:Integer(VolO.Blocks.Total) * (DATA:Integer(VolO.Blocks.Size) / 1024)
DeletedUsed = DATA:Integer(VolO.Blocks.Purgable) * (DATA:Integer(VolO.Blocks.Size) / 1024)
Used = ((DATA:Integer(VolO.Blocks.Total) - DATA:Integer(VolO.Blocks.Free)) * (DATA:Integer(VolO.Blocks.Size)) / 1024) - DeletedUsed
Free = DATA:Integer(VolO.Blocks.Free) * (DATA:Integer(VolO.Blocks.Size) / 1024) + DeletedUsed
UsedDir = DATA:Integer(VolO.DIR.Total) - DATA:Integer(VolO.Dir.Free)

SampTime(VolumeNumber) = DATE:Utf()
If (SaveVolUsed(VolumeNumber) != 0)
   SampDiff(VolumeNumber) = SampTime(VolumeNumber) - SaveSampTime(VolumeNumber)
   If (SampDiff(VolumeNumber) > 0)
      VolumeRateUsage = DATA:Integer((Used - SaveVolUsed(VolumeNumber)) / SampDiff(VolumeNumber))
   Else
      VolumeRateUsage = DATA:Integer(Used - SaveVolUsed(VolumeNumber))
   EndIf
EndIf

SaveVolUsed(VolumeNumber) = Used
SaveSampTime(VolumeNumber) = SampTime(VolumeNumber)

'Calc. the position for information
Col = 25 * (VolumeNumber - 1)
If (Col = 0); Col = 1; EndIf
Row = Param(1)

'Print("Statistics for volume ",NET:Server:Name(0),"/",VolO.Name);Newline
Blank = STR:Repeat(" ",10) + ""
WIN:At(Row,Col); WIN:Say("Volume Name:",Blank)
WIN:At(Row,Col); WIN:Say("Volume Name:[",STR:Sub(VolO.Name,1,8),"]")
WIN:At(Row + 1,Col); WIN:Say("Total Space:",Blank)
WIN:At(Row + 1,Col); WIN:Say("Total Space:",Total)
WIN:At(Row + 2,Col); WIN:Say("Space Used :",Blank)
WIN:At(Row + 2,Col); WIN:Say("Space Used :",Used)
WIN:At(Row + 3,Col); WIN:Say("Free Space :",Blank)
WIN:At(Row + 3,Col); WIN:Say("Free Space :",Free)
WIN:At(Row + 4,Col); WIN:Say("Total Dir. :",Blank)
WIN:At(Row + 4,Col); WIN:Say("Total Dir. :",VolO.Dir.Total)
WIN:At(Row + 5,Col); WIN:Say("Used Dir.  :",Blank)
WIN:At(Row + 5,Col); WIN:Say("Used Dir.  :",UsedDir)
WIN:At(Row + 6,Col); WIN:Say("Avail. Dir.:",Blank)
WIN:At(Row + 6,Col); WIN:Say("Avail. Dir.:",VolO.Dir.Free)
WIN:At(Row + 7,Col); WIN:Say("Fill KB/sec:",Blank)
WIN:At(Row + 7,Col); WIN:Say("Fill KB/sec:",VolumeRateUsage)
WIN:At(Row + 8,Col); WIN:Say("Sample sec :",Blank)
WIN:At(Row + 8,Col); WIN:Say("Sample sec :",SampDiff(VolumeNumber))

End Sub
Sub UpdateWindow
Local("j","oldWindow")

OldWindow = WIN:Select
WIN:Select(Param(1))
WIN:Color(WIN_FG_YELLOW + WIN_FG_LIGHT + WIN_BG_BLUE)
WIN:At(1,1); WIN:Say("Checking ...")
WIN:Color(WIN_FG_WHITE + WIN_FG_LIGHT + WIN_BG_BLUE)

j = 1
Do While (j <= Param(2))
   UpdateVolumeInfo(2,j)
   j = j + 1
EndDo

WIN:At(1,1); WIN:Say(STR:Repeat(" ",22))
WIN:Select(OldWindow)

End Sub
Sub YesNo

Return(RPC:Call(NULL,"YESNO.BAS",Param(1)))

End Sub
