-- NAM ASN1 Schema Definitions
-- Novell Inc.
-- 122 East 1700 South
-- Provo, UT 84606-6194

-- VeRsIoN=GRBeta 1.1
-- CoPyRiGhT=(c) Copyright 1996, Novell, Inc.  All rights reserved

-- Object ID Syntax
------------------------------------------
------------------------------------------
-- ASN1 Object ID's Defined as Follows:
--     joint-iso-ccitt(2) country(16) us(840) organization(1)
--     Novell(113719) applications(1) NAM(14) NAMAttributeType(4)
--                                            NAMAttributeSyntax(5)
--                                            NAMObjectClass(6)
------------------------------------------
-- One Additional Digit was added before the attribute or object
-- identifier to identify the release number.  This number reflects
-- the release number in which the object or attribute was added to the
-- definition.  The first release would have the ID 1 and count up from
-- there.
-- An example of the first attribute of the first release would be:
-- 2 16 840 1 113719 1 14 4 1 1.
-- The fourth attribute of the third relase would be:
-- 2 16 840 1 113719 1 14 4 3 4.
------------------------------------------


NAMSchemaExtentions DEFINITIONS ::=
BEGIN


-- New Attributes
------------------------------------------
------------------------------------------

"App Blurb" ATTRIBUTE ::=
{
  SyntaxID    SYN_CI_STRING,
  Flags       {DS_SINGLE_VALUED_ATTR, DS_STRING_ATTR},
  ASN1ObjID   {2 16 840 1 113719 1 14 4 1 1}
}

"App Contacts" ATTRIBUTE ::=
{
  SyntaxID    SYN_DIST_NAME,
  ASN1ObjID   {2 16 840 1 113719 1 14 4 1 2}
}

"App Drive Mappings" ATTRIBUTE ::=
{
  SyntaxID    SYN_CI_STRING,
  Flags       {DS_STRING_ATTR},
  ASN1ObjID   {2 16 840 1 113719 1 14 4 1 3}
}

"App Flags" ATTRIBUTE ::=
{
  SyntaxID    SYN_INTEGER,
  Flags       {DS_SINGLE_VALUED_ATTR},
  ASN1ObjID   {2 16 840 1 113719 1 14 4 1 4}
}

"App Icon" ATTRIBUTE ::=
{
  SyntaxID    SYN_STREAM,
  Flags       {DS_SINGLE_VALUED_ATTR},
  ASN1ObjID   {2 16 840 1 113719 1 14 4 1 5}
}

"App Parameters" ATTRIBUTE ::=
{
  SyntaxID    SYN_CI_STRING,
  Flags       {DS_SINGLE_VALUED_ATTR, DS_STRING_ATTR},
  ASN1ObjID   {2 16 840 1 113719 1 14 4 1 6}
}

"App Path" ATTRIBUTE ::=
{
  SyntaxID    SYN_CI_STRING,
  Flags       {DS_SINGLE_VALUED_ATTR, DS_STRING_ATTR},
  ASN1ObjID   {2 16 840 1 113719 1 14 4 1 7}
}

"App Printer Ports" ATTRIBUTE ::=
{
  SyntaxID    SYN_CI_STRING,
  Flags       {DS_STRING_ATTR},
  ASN1ObjID   {2 16 840 1 113719 1 14 4 1 8}
}

"App Shutdown Script" ATTRIBUTE ::=
{
  SyntaxID    SYN_STREAM,
  Flags       {DS_SINGLE_VALUED_ATTR},
  ASN1ObjID   {2 16 840 1 113719 1 14 4 1 9}
}

"App Startup Script" ATTRIBUTE ::=
{
  SyntaxID    SYN_STREAM,
  Flags       {DS_SINGLE_VALUED_ATTR},
  ASN1ObjID   {2 16 840 1 113719 1 14 4 1 10}
}

"App Working Directory" ATTRIBUTE ::=
{
  SyntaxID    SYN_CI_STRING,
  Flags       {DS_SINGLE_VALUED_ATTR, DS_STRING_ATTR},
  ASN1ObjID   {2 16 840 1 113719 1 14 4 1 11}
}

"Desktop" ATTRIBUTE ::=
{
  SyntaxID    SYN_DIST_NAME,
  ASN1ObjID   {2 16 840 1 113719 1 14 4 1 12}
}

"Auto Start" ATTRIBUTE ::=
{
  SyntaxID    SYN_TYPED_NAME,
  ASN1ObjID   {2 16 840 1 113719 1 14 4 1 13}
}

"Launcher Config" ATTRIBUTE ::=
{
  SyntaxID    SYN_STREAM,
  Flags       {DS_SINGLE_VALUED_ATTR},
  ASN1ObjID   {2 16 840 1 113719 1 14 4 1 14}
}


-- New Classes
------------------------------------------
------------------------------------------

"Application" OBJECT-CLASS ::=
{
  SubClassOf  {"TOP"},
  ContainedBy {"Organizational Unit", "Organization"},
  NamedBy     {"CN"},
  MustContain {"CN", "App Path", "Description"},
  MayContain  {"App Blurb", "App Contacts", "App Drive Mappings",
               "App Flags", "App Icon", "App Parameters",
               "App Printer Ports", "App Shutdown Script",
               "App Startup Script", "App Working Directory",
               "See Also"},
  ASN1ObjID   {2 16 840 1 113719 1 14 6 1 1}
}

"Application (DOS)" OBJECT-CLASS ::=
{
  SubClassOf  {"Application"},
  Flags       {DS_EFFECTIVE_CLASS},
  ASN1ObjID   {2 16 840 1 113719 1 14 6 1 2}
}

"Application (Windows 3.x)" OBJECT-CLASS ::=
{
  SubClassOf  {"Application"},
  Flags       {DS_EFFECTIVE_CLASS},
  ASN1ObjID   {2 16 840 1 113719 1 14 6 1 3}
}

"Application (Windows 95)" OBJECT-CLASS ::=
{
  SubClassOf  {"Application"},
  Flags       {DS_EFFECTIVE_CLASS},
  ASN1ObjID   {2 16 840 1 113719 1 14 6 1 4}
}

"Application (Windows NT)" OBJECT-CLASS ::=
{
  SubClassOf  {"Application"},
  Flags       {DS_EFFECTIVE_CLASS},
  ASN1ObjID   {2 16 840 1 113719 1 14 6 1 5}
}


-- Modification of Existing Classes
------------------------------------------
------------------------------------------

"User" OBJECT-CLASS ::=
{
  Operation   MODIFY,
  MayContain  {"Desktop", "Auto Start", "Launcher Config"}
}

"Organization" OBJECT-CLASS ::=
{
  Operation   MODIFY,
  MayContain  {"Desktop", "Auto Start", "Launcher Config"}
}

"Organizational Unit" OBJECT-CLASS ::=
{
  Operation   MODIFY,
  MayContain  {"Desktop", "Auto Start", "Launcher Config"}
}

"Group" OBJECT-CLASS ::=
{
  Operation   MODIFY,
  MayContain  {"Desktop", "Auto Start"}
}

END
