
#include "rcgi.h"
#include <string.h>
#include <nwenvrn.h> /* For GetFileServerName() */

int process_request();

main(int argc, char **argv)
{

	/********* Typical calls in the beginning of the main program ****/
	/********* Use rcgi_cleanup() to cleanup RCGI stuff before you exit ***/


	atexit(rcgi_cleanup);
	AtUnload(rcgi_cleanup);

	/****** Process Command line parameters to get the port number ****/
	/****** on which this RCGI server should listen for requests   ****/

	if (argc != 1 && argc != 3) 
		wrong_args();
	
	if (argc > 1) { 
		/** So we have some arguments, now check them **/

		if (argv[1][0] != '-' && argv[1][0] != '/')
			wrong_args();
		if (argv[1][1] != 'p' && argv[1][1] != 'P')
			wrong_args();
	}

	/********** Done with processing command line parameters *******/
	/********** Now lets get down to business                *******/
	/********** Invoke rcgi_main() to get and process requests *****/
	/********** and data from the web server using RCGI      *******/

	if (argc == 3)  
		/** We have the port number so pass it to the RCGI processor **/
		rcgi_main(argv[2], process_request);
	else
		/** no port number so the RCGI processor uses the default **/
		rcgi_main(NULL, process_request);

}

int process_request()
{
	/***** When this function gets invoked, all of the RCGI      ****/
	/***** processing is done. Now all stdin data is stored in   ****/
	/***** the "input" array, all environment data is in the     ****/
	/***** "env" array and all command line parameter data is in ****/
	/***** the "cmd_line" array. Now use this info to do the task****/
	/***** at hand and send the results back using the support fns ***/

	char name[3000], *cptr;
	int i=0;

	memset(name, 0, 3000);
	cptr = name;
	strcat(cptr, "File Server Name is :");
	cptr += strlen("File Server Name is :");
	GetFileServerName(0, cptr);
	strcat(cptr, "\r\n");
	strcat(cptr, "Environment variables are :");
	strcat(cptr, "\r\n");
	for (i=0;i<env_count;i++){
		strcat(cptr, env[i]);
		strcat(cptr, "\r\n");
	}

	/******* Now use the RCGI support function to send a standard header **/
	rcgi_sendheader();

	/******* Use the RCGI support function to send your reply **/
	rcgi_sendreply(name);
	return 0;
}

/*** Used to print an error message about command line args ***/
wrong_args() 
{
		printf("Wrong Arguments\n");
		printf("Usage : load testcgi.nlm [-p port_num]\n");
		exit(1);
}
