/*******************************************************************************
**
** (c) Copyright 1996 Novell, Inc.  All rights reserved.
**
** File Name:  xxDebug.C -- CGI Extension Processor Debug Facility.
**
**  $Logfile:   J:/webserv/prodtree/disk1/web/samples/cginph/src/vcs/xxdebug.c_v  $
** $Revision:   1.0  $
**     $Date:   10 Apr 1996 11:33:20  $
**   $Author:   PTANG  $
**
**  Comments:  This file contains a set of Netware Internal Debugger routines
**             tailored specificly for debugging the NetWare HTTP Server/CGI
**             interface.
**
** 
** Functions contained in this file:
**
**    xxDbgChkClose        // Check whether to close the current debug session
**    xxDbgChkOpen         // Check whether to open a debug session
**    xxDbgCmdLnParser     // Parse and process commands
**    xxDbgCmdProcDeInit   // Deregister the command processor
**    xxDbgCmdProcInit     // Register the command processor
**    xxDbgDispLoc         // Display the name of the currently executing routine
**    xxDbgExample         // Simple debug formatting example
**    xxDbgHookSysMsg      // Hooks CsSysMsg and opens a debug session
**    xxDbgFile            // Do a pseudo sprintf() and output to the file
**    xxDbgFlush           // Flush the current logical file to disk
**    xxDbgFmtHex          // Format the raw data to the output file
**    xxDbgScrn            // Do a pseudo sprintf() and output to the screen
**    xxDbgWrite           // Send data to output w/o any sprintf() formatting 
**       
**       
**      $Log:   J:/webserv/prodtree/disk1/web/samples/cginph/src/vcs/xxdebug.c_v  $
 * 
 *    Rev 1.0   10 Apr 1996 11:33:20   PTANG
 * Initial revision.
**  
*******************************************************************************/

#include <sys\types.h>
#include <nwtypes.h>
#include <string.h>
#include <process.h>
#include <nwlocale.h>
#include <errno.h>
#include <conio.h>

#include "csSysMsg.h"         // CSSYSMSG.NLM:  SysMsg Prototype Definitions
#include "cgiNph.Fpd"         // PC-Lint Generated Prototype Definitions File.


/******************************************************************************/
/*********************** xxDbg External/Forward Definitions *******************/
/******************************************************************************/

// Data structure for RegisterConsoleCommand

struct commandParserStructure
{
   struct commandParserStructure *Link; /* Set by RegisterConsoleCommand */
   LONG (*parseRoutine)(                /* parsing routing (user defined) */
         LONG screenID,
         BYTE *commandLine);
   struct ResourceTagStructure *RTag;   /* Set to resource tag */
};

/******************************************************************************/
/*************************** xxDbg Global Definitions *************************/
/******************************************************************************/

struct CeDbg_t
      *  xx_DbgInfo           =  NULL;       // CeLib debug info struct
LONG     xx_DbgLevel          =  0;          // CeDbg_Screen | CeDbg_File | CeDbg_Fmt;
LONG     xx_DbgOption         =  CeDbg_MemoryFile
                                 | CeDbg_AppendFile
                                 | CeDbg_SnapShotHeader
                                 | CeDbg_FmtHexWithTime;
LONG     xx_DbgFileSize       =  1024;       // limit the memory file in Kb
char     xx_DbgFileName [64]  =  {"Sys:Web\\Cgi-Bin\\xxCgiDbg.Log"};
char     xx_DbgSessTag  [32]  =  {""};       // No session tag defined
LONG     xx_DbgDispLoc        =  FALSE;      // Disable the display current loc output

                                 // NOTE:  If you do not specify a debug screen,
                                 // ALL debug output will be maintained as a 
                                 // memory file (which is VERY fast) and will
                                 // speed up execution of the extension NLM.

char     xx_DbgScrnName [64]  =  {"NetWare HTTP CGI Extension Processor Debug Screen"};

struct commandParserStructure
         xx_CmdParser;                       // RegisterConsoleCommand parms
LONG     xx_CmdProcInit       =  FALSE;      // used in shutdown to determine whether it's been intialized

struct ScreenStruct
      *  xx_ScrnId;                          // global debug screen ID

struct ResourceTagStructure                  // Strucure tag used to register
      *  xx_DbgRTag           =  NULL;       // the debug command processor


/*******************************************************************************
 *
 * Name:          xxDbgChkClose()
 *
 * Check to see whether Debugging is currently enabled and if so, whether the
 * user has asked to have it disabled.  If it's to be disabled, we close the
 * log file and destroy the debug screen.
 *
 * Returns:       nothing
 *
 ******************************************************************************/

void xxDbgChkClose (void)
{
   if (xx_DbgInfo != NULL && xx_DbgLevel == 0)
   {
      xxDbgScrn   ("NetWare HTTP CGI extension debug session deinitialized.\r\n");
      CeDbgDeInit (&xx_DbgInfo);
   }
}


/*******************************************************************************
 *
 * Name:          xxDbgChkOpen()
 *
 * Check to see if debugging has been enabled by the user for current session.
 * If so, open the Streams Debug Screen and possibly the debug log file.
 *
 * Returns:       nothing
 *
 ******************************************************************************/

void xxDbgChkOpen (void)
{
   if (xx_DbgInfo == NULL && xx_DbgLevel != 0)
   {
      CeDbgInit (xx_NlmID,
                 xx_DbgOption,
                 xx_DbgSessTag,
                 &xx_DbgLevel,
                 xx_DbgFileName,
                 xx_DbgFileSize,
                 xx_DbgScrnName,
                 &xx_DbgInfo);
      
      xxDbgScrn      ("NetWare HTTP CGI extension debug session initialized.\r\n");
   }
   else if (xx_DbgInfo != NULL && xx_DbgLevel == 0)
   {
      xxDbgChkClose ();
   }
}


/*******************************************************************************
 *
 * Name:          xxDbgCmdLnParser()
 *
 * This routine will be called by the NetWare OS when an unrecognized command
 * is entered at the NetWare console.  If the command is defined within this
 * routine, zero is returned to the OS indicating that the command will be
 * processed by this routine.
 *
 * Returns:
 *
 *    CS_CMD_NOT_FOUND  (-1)  Not one of our defined commands
 *    CS_CMD_FOUND      (0)   It is one of ours, so we'll handle it
 *
 ******************************************************************************/

LONG  xxDbgCmdLnParser (LONG screenID, BYTE * cmdLine)
{
   #define  CS_CMD_NOT_FOUND  -1                /* --> not a CGI command */
   #define  CS_CMD_FOUND      0                 /* --> valid CGI command */

   int      OsThrdGrpID			=  -1;
   LONG     retCode				=  CS_CMD_FOUND;
   LONG     sLen;
   LONG     scrnID;
   BYTE  *  sPtr;

   (void)   screenID;            // unreferenced symbol
   
   if (xx_ThreadGroupID != 0)
   {
      OsThrdGrpID = SetThreadGroupID (xx_ThreadGroupID);
   }

   cmdLine = CeSkipWhite (cmdLine);
   
   if (strnicmp (xx_NlmName, cmdLine, sLen = strlen (xx_NlmName)) != 0)
   {
      retCode = (LONG) CS_CMD_NOT_FOUND;
   }
   else
   {
      if (*(cmdLine = CeSkipToken (cmdLine, NULL)) == '\0')
      {
         // Only the name of the CGI NLM was entered on the command line so
         // we only output the following help screen for the user.
         
         if ((scrnID = CreateScreen ("NetWare HTTP Server/CGI Extenstion Help Screen", AUTO_DESTROY_SCREEN)) != EFAILURE)
         {
            SetCurrentScreen  (scrnID);
            DisplayScreen     (scrnID);
            
            NWprintf ("NetWare HTTP Server/CGI Extenstion Help Screen\r\n"
                      "\r\n"
                      "   CgiNph Flush \r\n"
                      "      Flushes the current debug session file to disk.\r\n"
                      "\r\n"
                      "   CgiNph DbgLoc \r\n"
                      "      Enables/Disables formatting of procedure names as they're called.\r\n"
                      "\r\n"
                      "   CgiNph DbgOff \r\n"
                      "      Closes the current debug session.\r\n"
                      "\r\n"
                      "   CgiNph DbgOn \r\n"
                      "      Enable the CsSysMsg Debug subsystem for the CGI Nlm.\r\n"
                      "\r\n");
            
            PressAnyKeyToContinue   ();           
            DestroyScreen           (scrnID);
         }
         
         if ((scrnID = CreateScreen ("System Console", 0)) != EFAILURE)
         {
            SetCurrentScreen  (scrnID);
            DisplayScreen     (scrnID);
         }
      }
      else
      {
         // Otherwise, more than just the name of this NLM has been entered
         // on the command line, so we parse the line to determine whether
         // it's one defined by this module.  If not, we return the appropriate
         // return code and the OS will output a command not found message.
         
         cmdLine = CeSkipWhite (cmdLine);
         
         if ((strnicmp ("Flush", (char *) cmdLine, sLen = strlen ("Flush")) == 0) &&
             (cmdLine [sLen] == ' ' || cmdLine [sLen] == '\0'))
         {
            xxDbgFlush  ();
            NWprintf    ("\r\nNetWare HTTP CGI debug file has been flushed.\r\n\r\n");
         }
         else if ((strnicmp ("DbgLoc", (char *) cmdLine, sLen = strlen ("DbgLoc")) == 0) &&
                  (cmdLine [sLen] == ' ' || cmdLine [sLen] == '\0'))
         {
            if (xx_DbgDispLoc == FALSE)
            {
               xx_DbgDispLoc  =  TRUE;
               sPtr           =  "\r\nProcedure call formatting enabled.\r\n\r\n";
            }
            else
            {
               xx_DbgDispLoc  =  FALSE;
               sPtr           =  "\r\nProcedure call formatting disabled.\r\n\r\n";
            }
            NWprintf (sPtr);
         }
         else if ((strnicmp ("DbgOff", (char *) cmdLine, sLen = strlen ("DbgOff")) == 0) &&
                  (cmdLine [sLen] == ' ' || cmdLine [sLen] == '\0'))
         {
            xx_DbgLevel    =  0;
            xxDbgChkClose  ();
            NWprintf       ("\r\nNetWare HTTP CGI debugging disabled.\r\n\r\n");
         }
         else if ((strnicmp ("DbgOn", (char *) cmdLine, sLen = strlen ("DbgOn")) == 0) &&
                  (cmdLine [sLen] == ' ' || cmdLine [sLen] == '\0'))
         {
            xxDbgHookSysMsg   ();
            NWprintf          ("\r\nNetWare HTTP CGI debugging enabled.\r\n\r\n");
         }
         else
         {
            retCode = (LONG) CS_CMD_NOT_FOUND;
         }
      }
   }

   if (OsThrdGrpID != -1)
   {
      SetThreadGroupID (OsThrdGrpID);
   }
   return (retCode);
}


/*******************************************************************************
 *
 * Name:          xxDbgCmdProcDeInit()
 *
 * This routine is used to deregister the command line processing routine with
 * the OS.  Any open debug session are also closed at this time.
 *
 * Returns:       Always returns SUCCESS.
 *
 ******************************************************************************/

LONG  xxDbgCmdProcDeInit (void)
{
   extern LONG UnRegisterConsoleCommand (void *commandParserToDelete);
   
   if (xx_CmdProcInit == TRUE)
   {
      xx_DbgLevel                =  0;
      xxDbgChkClose              ();
      UnRegisterConsoleCommand   (&xx_CmdParser);
      xx_CmdProcInit             =  FALSE;
   }
   return   (SUCCESS);
}


/*******************************************************************************
 *
 * Name:          xxDbgCmdProcInit()
 *
 * This routine is used to register this modules command line processing
 * routine with the NetWare OS.
 *
 * Returns:       Always returns SUCCESS.
 *
 ******************************************************************************/

LONG  xxDbgCmdProcInit (void)
{
   #define  ConsoleCommandSignature       0x4D4F4343
   extern   LONG RegisterConsoleCommand   (struct commandParserStructure *__newCommandParser);
   extern   LONG AllocateResourceTag      (LONG   __NLMHandle,
                                           BYTE * __descriptionString,
                                           LONG   __resourceType);


   if ((xx_CmdParser.RTag = (struct ResourceTagStructure *)
                               AllocateResourceTag (xx_NlmHandle,
                                          (BYTE *) "Console Command",
                                          ConsoleCommandSignature)) != 0)
   {
      xx_CmdParser.parseRoutine  =  xxDbgCmdLnParser;
      RegisterConsoleCommand     (&xx_CmdParser);
      xx_CmdProcInit             =  TRUE;          // == cmd processor intialized
   }
   return         (SUCCESS);
}


/*******************************************************************************
 *
 * Name:          xxDbgDispLoc()
 *
 * This debug routine is used to display the program flow of this module as it
 * executes.
 *
 * Returns:       Nothing.
 *
 ******************************************************************************/

void  xxDbgDispLoc (BYTE * procName)     // calling procedure name.
{
   if (xx_DbgInfo != NULL && xx_DbgDispLoc != 0)
   {
      CeDbgFile   (xx_DbgInfo, "***      In %s()\r\n", procName);
   }
}


/*******************************************************************************
 *
 * Name:          xxDbgExample()
 *
 * Simple formatting example.
 *
 * Returns:       nothing
 *
 ******************************************************************************/

#if 0
void xxDbgExample (samplePtr_t * reqPtr)
{
   if (xx_DbgInfo != NULL)
   {
      xxDbgFile   ("--- Formatted CNS_DGNTRACE_STOP_REQ Primitive ---\r\n");
      xxDbgFile   ("----------------- CNSStopDGNTrace_t -------------\r\n");   
      xxDbgFile   ("              PrimType: %x \r\n", reqPtr->PrimType);
      xxDbgFile   ("              UserParm: %x \r\n", reqPtr->UserParm);
      xxDbgFile   ("               TraceId: %x \r\n", reqPtr->TraceId);
      xxDbgFile   ("-------------------------------------------------\r\n");
   }
}        
#endif


/*******************************************************************************
 *
 * Name:          xxDbgHookSysMsg()
 *
 * This routine is called to determine whether a debug session has be
 * intialized, and if not, will open one with the CsSysMsg NLM.
 *
 * Returns:       Always returns SUCCESS.
 *
 ******************************************************************************/

int   xxDbgHookSysMsg (void)
{
   int   retCode     =  SUCCESS;
   
   if (xx_DbgLevel == 0)
   {
      xx_DbgLevel    =  CeDbg_File | CeDbg_Fmt;
      
      if (*xx_DbgScrnName != 0)
      {
         xx_DbgLevel |= CeDbg_Screen;
      }
      xxDbgChkOpen   ();
   }
   return (retCode);
}


/*******************************************************************************
 *
 * Name:          xxDbgFile()
 *
 * Do a pseudo NWsprintf () and output the dbgBuf to the output file.
 *
 * Returns:       nothing
 *
 ******************************************************************************/

void  xxDbgFile (char * dbgStr, ...)
{
   va_list  vaArgs;

   if (xx_DbgInfo != NULL)
   {
      va_start    (vaArgs, dbgStr);
      CeDbgFileVA (xx_DbgInfo, dbgStr, vaArgs);
      va_end      (vaArgs);
   }
}


/*******************************************************************************
 *
 * Name:          xxDbgFlush()
 *
 * Flush the current contents of the debug file to disk.
 *
 * Returns:       nothing
 *
 ******************************************************************************/

void  xxDbgFlush (void)
{
   if (xx_DbgInfo != NULL)
   {
      CeDbgFlush  (xx_DbgInfo);
   }
}



/*******************************************************************************
 *
 * Name:          xxDbgFmtHex()
 *
 * Format the raw data to the output file.
 *
 * Returns:       nothing
 *
 ******************************************************************************/

void  xxDbgFmtHex (BYTE     *  pData,     // ptr to data to be formatted
                   LONG        dataLen,   // byte len of data
                   LONG        offset)    // beginning logical offset for display
{
   LONG     saveDbgLevel      =  xx_DbgLevel;

   if (xx_DbgInfo != NULL)
   {
      xx_DbgLevel    &= ~CeDbg_Screen;
      CeDbgFmtHex    (xx_DbgInfo, pData, dataLen, offset);
      xx_DbgLevel    =  saveDbgLevel;
   }
}


/*******************************************************************************
 *
 * Name:          xxDbgScrn()
 *
 * Do a pseudo NWsprintf () and output the dbgBuf to the debug screen.  Also,
 * if level 2 debugging has been enabled, output the dbgBuf to the debug file.
 *
 * Returns:       nothing
 *
 ******************************************************************************/

void xxDbgScrn (char * dbgStr, ...)
{
   va_list  vaArgs;

   if (xx_DbgInfo != NULL)
   {
      va_start       (vaArgs, dbgStr);
      CeDbgScrnVA    (xx_DbgInfo, dbgStr, vaArgs);
      va_end         (vaArgs);
   }
}


/*******************************************************************************
 *
 * Name:          xxDbgWrite()
 *
 * Write the dbgBuf to the debug output file.
 *
 * Returns:       nothing
 *
 ******************************************************************************/

void  xxDbgWrite (char * dbgBuf)
{
   if (xx_DbgInfo != NULL)
   {
      CeDbgWrite  (xx_DbgInfo, dbgBuf);
   }
}

/******************************************************************************/
