/* $Id: log.c,v 1.1.1.1 1995/07/09 18:25:44 brad Exp $ */
/*
   log.c

   system logging routines for rcgid
*/

#include "rcgid.h"

#include <stdio.h>
#include <string.h>
#include <syslog.h>

static int local_log;

int
log_pid()
{
    FILE *pid_file;
    char pid_file_name[MAX_FNAME];

    sprintf(pid_file_name, "rcgid.pid");
    if (!(pid_file = fopen(pid_file_name,"w"))) {
        fprintf(stderr, "rcgid: could not log pid to file %s\n",
		pid_file_name);
	return -1;
    }

    fprintf(pid_file, "%d\n", getpid());
    fclose(pid_file);
    return 0;
}

void
set_local_log()
{
    local_log = 1;
}

char *
get_time()
{
    time_t t;
    char *time_string;

    t = time(NULL);

    time_string = ctime(&t);
    time_string[strlen(time_string) - 1] = '\0';

    return (time_string);
}

int
log_error(msg)
char *msg;
{
    if (local_log) {
	FILE *log;
	char logfile[MAX_FNAME];

	sprintf(logfile, "rcgid.log");
	if (log = fopen(logfile, "a")) {
	    fprintf(log, "[%s] %s\n", get_time(), msg);
	    fclose(log);
	}

	return;
    }

    syslog(LOG_WARNING, msg);
}

