# include "Shapes.h"
# include "yyShapes.w"
# include <stdio.h>
# if defined __STDC__ | defined __cplusplus
#  include <stdlib.h>
# else
   extern void exit ();
# endif
# include "Tree.h"
# include "Definiti.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 79 "Shapes.puma"

# include "Tree.h"
# include "Idents.h"
# include "StringMe.h"
# include "Definiti.h"

# include "Types.h"  /* ArrayFormals */



static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Shapes, routine %s failed\n", yyFunction);
 exit (1);
}

void SetCurrentShape ARGS((tTree t));
static void SetCurrentShapeList ARGS((tTree formals, tTree actuals));
void DelCurrentShape ARGS((tTree t));
static void DelCurrentShapeList ARGS((tTree formals));
void SetAllocateShapes ARGS((tTree t));
void ResetDeallocateShapes ARGS((tTree t));
void GetCurrentShape ARGS((tTree t, shape s));
static void GetCurrentShapeObj ARGS((tDefinitions t, shape s));
static void GetCurrentShapeList ARGS((tTree t, shape s, int n));
void PrintCurrentShape ARGS((shape s));
tTree MakeFullShape ARGS((tTree t));
static void MakeFullIndexShape ARGS((tTree t, shape s, int n));
bool IsWholeVar ARGS((tTree t));
static bool FullIndexSlices ARGS((tTree t, shape s, int n));
static bool FullIndexSlice ARGS((tTree t, shape s, int n));
static void PrintCompare ARGS((tTree e1, tTree e2, bool is));
tTree NormalizeShape ARGS((tTree t));
bool IsContiguousSection ARGS((tTree t));
static bool IsContiguousShape ARGS((tTree t, shape s, int n));
static bool SingleIndexes ARGS((tTree indexes));

void SetCurrentShape
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t == NoTree) return;
  if (t->Kind == kINDEXED_VAR) {
  if (t->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
# line 97 "Shapes.puma"
  {
# line 98 "Shapes.puma"
   SetCurrentShapeList (ArrayFormals (t->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Object), t->INDEXED_VAR.IND_EXPS);
  }
   return;

  }
  }
# line 101 "Shapes.puma"
  {
# line 102 "Shapes.puma"
   printf ("SetCurrentShape fails\n");
# line 103 "Shapes.puma"
   FileUnparse (stdout, t);
# line 104 "Shapes.puma"
   WriteTree (stdout, t);
# line 105 "Shapes.puma"
   exit (- 1);
  }
   return;

;
}

static void SetCurrentShapeList
# if defined __STDC__ | defined __cplusplus
(register tTree formals, register tTree actuals)
# else
(formals, actuals)
 register tTree formals;
 register tTree actuals;
# endif
{
  if (formals == NoTree) return;
  if (actuals == NoTree) return;
  if (formals->Kind == kTYPE_LIST) {
  if (actuals->Kind == kBTE_LIST) {
# line 110 "Shapes.puma"
  {
# line 111 "Shapes.puma"
   SetCurrentShapeList (formals->TYPE_LIST.Elem, actuals->BTE_LIST.Elem);
# line 112 "Shapes.puma"
   SetCurrentShapeList (formals->TYPE_LIST.Next, actuals->BTE_LIST.Next);
  }
   return;

  }
  }
  if (formals->Kind == kDYNAMIC) {
# line 115 "Shapes.puma"
  {
# line 116 "Shapes.puma"
 if (formals->DYNAMIC.Shape != NoTree)
        printf ("Warning: Shape has been reset for one dimension\n");

# line 119 "Shapes.puma"
   formals->DYNAMIC.Shape = actuals;
  }
   return;

  }
  if (formals->Kind == kTYPE_EMPTY) {
  if (actuals->Kind == kBTE_EMPTY) {
# line 122 "Shapes.puma"
   return;

  }
# line 130 "Shapes.puma"
  {
# line 131 "Shapes.puma"
   printf ("SetCurrentShapeList: more actuals than formals\n");
# line 132 "Shapes.puma"
   exit (- 1);
  }
   return;

  }
  if (actuals->Kind == kBTE_EMPTY) {
# line 125 "Shapes.puma"
  {
# line 126 "Shapes.puma"
   printf ("SetCurrentShapeList: more formals than actuals\n");
# line 127 "Shapes.puma"
   exit (- 1);
  }
   return;

  }
# line 135 "Shapes.puma"
  {
# line 136 "Shapes.puma"
   printf ("SetCurrentShapeList fails\n");
# line 137 "Shapes.puma"
   printf ("formals : ");
# line 137 "Shapes.puma"
   FileUnparse (stdout, formals);
# line 137 "Shapes.puma"
   printf ("\n");
# line 138 "Shapes.puma"
   printf ("actuals : ");
# line 138 "Shapes.puma"
   FileUnparse (stdout, actuals);
# line 138 "Shapes.puma"
   printf ("\n");
# line 139 "Shapes.puma"
   WriteTree (stdout, formals);
# line 140 "Shapes.puma"
   WriteTree (stdout, actuals);
# line 141 "Shapes.puma"
   error_protocol ("something is wrong with SetCurrentShapeList");
# line 142 "Shapes.puma"
   kill_in_protocol ();
  }
   return;

;
}

void DelCurrentShape
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t == NoTree) return;
  if (t->Kind == kUSED_VAR) {
# line 153 "Shapes.puma"
  {
# line 154 "Shapes.puma"
   DelCurrentShapeList (ArrayFormals (t->USED_VAR.VARNAME->VAR_OBJ.Object));
  }
   return;

  }
# line 157 "Shapes.puma"
  {
# line 158 "Shapes.puma"
   printf ("DelCurrentShape fails\n");
# line 159 "Shapes.puma"
   FileUnparse (stdout, t);
# line 160 "Shapes.puma"
   WriteTree (stdout, t);
# line 161 "Shapes.puma"
   exit (- 1);
  }
   return;

;
}

static void DelCurrentShapeList
# if defined __STDC__ | defined __cplusplus
(register tTree formals)
# else
(formals)
 register tTree formals;
# endif
{
  if (formals == NoTree) return;
  if (formals->Kind == kTYPE_LIST) {
# line 166 "Shapes.puma"
  {
# line 167 "Shapes.puma"
   DelCurrentShapeList (formals->TYPE_LIST.Elem);
# line 168 "Shapes.puma"
   DelCurrentShapeList (formals->TYPE_LIST.Next);
  }
   return;

  }
  if (formals->Kind == kDYNAMIC) {
# line 171 "Shapes.puma"
  {
# line 172 "Shapes.puma"
 if (formals->DYNAMIC.Shape == NoTree)
        printf ("Warning: Shape in one dimension was already deleted\n");

# line 175 "Shapes.puma"
   formals->DYNAMIC.Shape = NoTree;
  }
   return;

  }
;
}

void SetAllocateShapes
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t == NoTree) return;
  if (t->Kind == kBTP_LIST) {
  if (t->BTP_LIST.Elem->Kind == kVAR_PARAM) {
# line 186 "Shapes.puma"
  {
# line 187 "Shapes.puma"
   SetCurrentShape (t->BTP_LIST.Elem->VAR_PARAM.V);
# line 188 "Shapes.puma"
   SetAllocateShapes (t->BTP_LIST.Next);
  }
   return;

  }
  }
;
}

void ResetDeallocateShapes
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t == NoTree) return;
  if (t->Kind == kBTP_LIST) {
  if (t->BTP_LIST.Elem->Kind == kVAR_PARAM) {
# line 199 "Shapes.puma"
  {
# line 200 "Shapes.puma"
   DelCurrentShape (t->BTP_LIST.Elem->VAR_PARAM.V);
# line 201 "Shapes.puma"
   ResetDeallocateShapes (t->BTP_LIST.Next);
  }
   return;

  }
  }
;
}

void GetCurrentShape
# if defined __STDC__ | defined __cplusplus
(register tTree t, shape s)
# else
(t, s)
 register tTree t;
 shape s;
# endif
{
  if (t == NoTree) return;
  if (t->Kind == kINDEXED_VAR) {
# line 212 "Shapes.puma"
  {
# line 213 "Shapes.puma"
   GetCurrentShape (t->INDEXED_VAR.IND_VAR, s);
  }
   return;

  }
  if (t->Kind == kUSED_VAR) {
# line 216 "Shapes.puma"
  {
# line 217 "Shapes.puma"
   GetCurrentShape (t->USED_VAR.VARNAME, s);
  }
   return;

  }
  if (t->Kind == kVAR_OBJ) {
# line 220 "Shapes.puma"
  {
# line 221 "Shapes.puma"
   GetCurrentShapeObj (t->VAR_OBJ.Object, s);
  }
   return;

  }
;
}

static void GetCurrentShapeObj
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t, shape s)
# else
(t, s)
 register tDefinitions t;
 shape s;
# endif
{
  if (t == NoDefinitions) return;
  if (t->Kind == kVarObject) {
  if (t->VarObject.decl->Kind == kVAR_DECL) {
  if (t->VarObject.decl->VAR_DECL.VAL->Kind == kARRAY_TYPE) {
# line 226 "Shapes.puma"
  {
# line 227 "Shapes.puma"
   GetCurrentShapeList (t->VarObject.decl->VAR_DECL.VAL->ARRAY_TYPE.ARRAY_INDEX_TYPES, s, 1);
  }
   return;

  }
  }
  if (t->VarObject.decl->Kind == kVAR_PARAM_DECL) {
  if (t->VarObject.decl->VAR_PARAM_DECL.VAL->Kind == kARRAY_TYPE) {
# line 230 "Shapes.puma"
  {
# line 231 "Shapes.puma"
   GetCurrentShapeList (t->VarObject.decl->VAR_PARAM_DECL.VAL->ARRAY_TYPE.ARRAY_INDEX_TYPES, s, 1);
  }
   return;

  }
  }
  }
# line 234 "Shapes.puma"
  {
# line 235 "Shapes.puma"
 s->rank = 0;
  }
   return;

;
}

static void GetCurrentShapeList
# if defined __STDC__ | defined __cplusplus
(register tTree t, shape s, register int n)
# else
(t, s, n)
 register tTree t;
 shape s;
 register int n;
# endif
{
  if (t == NoTree) return;
  if (t->Kind == kTYPE_LIST) {
  if (t->TYPE_LIST.Elem->Kind == kDYNAMIC) {
# line 240 "Shapes.puma"
  {
# line 241 "Shapes.puma"
 if (t->TYPE_LIST.Elem->DYNAMIC.Shape == NoTree)
         { printf ("Shape of dynamic array unknown\n");
           printf ("Seems to be use for allocate\n");
           exit (-1);
         }

# line 247 "Shapes.puma"
   GetCurrentShapeList (t->TYPE_LIST.Elem, s, n);
# line 248 "Shapes.puma"
   GetCurrentShapeList (t->TYPE_LIST.Next, s, n + 1);
  }
   return;

  }
  if (t->TYPE_LIST.Elem->Kind == kINDEX_TYPE) {
# line 251 "Shapes.puma"
  {
# line 252 "Shapes.puma"
   GetCurrentShapeList (t->TYPE_LIST.Elem, s, n);
# line 253 "Shapes.puma"
   GetCurrentShapeList (t->TYPE_LIST.Next, s, n + 1);
  }
   return;

  }
  }
  if (t->Kind == kTYPE_EMPTY) {
# line 256 "Shapes.puma"
   return;

  }
  if (t->Kind == kDYNAMIC) {
  if (t->DYNAMIC.Shape->Kind == kSLICE_EXP) {
# line 259 "Shapes.puma"
  {
# line 260 "Shapes.puma"
 s->rank = n;
      s->bounds[n-1][0] = t->DYNAMIC.Shape->SLICE_EXP.START;
      s->bounds[n-1][1] = t->DYNAMIC.Shape->SLICE_EXP.STOP;
      s->bounds[n-1][2] = NoTree;

  }
   return;

  }
# line 275 "Shapes.puma"
  {
# line 276 "Shapes.puma"
   printf ("dynamic shape not normaliyed\n");
# line 277 "Shapes.puma"
   WriteTree (stdout, t);
# line 278 "Shapes.puma"
   kill_in_protocol ();
  }
   return;

  }
  if (t->Kind == kINDEX_TYPE) {
# line 267 "Shapes.puma"
  {
# line 268 "Shapes.puma"
 s->rank = n;
      s->bounds[n-1][0] = t->INDEX_TYPE.LOWER;
      s->bounds[n-1][1] = t->INDEX_TYPE.UPPER;
      s->bounds[n-1][2] = NoTree;

  }
   return;

  }
;
}

void PrintCurrentShape
# if defined __STDC__ | defined __cplusplus
(shape s)
# else
(s)
 shape s;
# endif
{
# line 283 "Shapes.puma"

int i;

# line 287 "Shapes.puma"
  {
# line 288 "Shapes.puma"
 printf ("Shape is : \n");
    for (i=0;i<s->rank;i++)
     { FileUnparse (stdout, s->bounds[i][0]);
       printf (" - ");
       FileUnparse (stdout, s->bounds[i][1]);
       if (s->bounds[i][2] != NoTree)
         { printf (" step ");
           FileUnparse (stdout, s->bounds[i][2]);
         }
       printf ("\n");
     }

  }
   return;

;
}

tTree MakeFullShape
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 316 "Shapes.puma"

struct_shape shp;
int i;
tTree ind, newvar, inc;

  if (t->Kind == kUSED_VAR) {
# line 322 "Shapes.puma"
  {
# line 323 "Shapes.puma"
   if (! (VarRank (t->USED_VAR.VARNAME->VAR_OBJ.Object) == 0)) goto yyL1;
  }
   return t;
yyL1:;

# line 327 "Shapes.puma"
  {
# line 328 "Shapes.puma"
 GetCurrentShape (t, &shp);
     ind = mBTE_EMPTY ();
     for (i=shp.rank; i>0; i--)
       { inc = shp.bounds[i-1][2];
         if (inc == NoTree) inc = mDUMMY_EXP();
         ind = mBTE_LIST (mSLICE_EXP (shp.bounds[i-1][0],
                 shp.bounds[i-1][1], inc), ind);
       }
     newvar = mINDEXED_VAR (t, ind);

  }
   return newvar;

  }
  if (t->Kind == kINDEXED_VAR) {
  if (t->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
# line 341 "Shapes.puma"
  {
# line 342 "Shapes.puma"

     GetCurrentShape (t, &shp);
     MakeFullIndexShape (t->INDEXED_VAR.IND_EXPS, &shp, 0);

  }
   return t;

  }
  }
# line 349 "Shapes.puma"
  {
# line 350 "Shapes.puma"
   printf ("MakeFullShape failed\n");
# line 351 "Shapes.puma"
   FileUnparse (stdout, t);
# line 352 "Shapes.puma"
   WriteTree (stdout, t);
# line 353 "Shapes.puma"
   kill_in_protocol ();
  }
   return t;

}

static void MakeFullIndexShape
# if defined __STDC__ | defined __cplusplus
(register tTree t, shape s, register int n)
# else
(t, s, n)
 register tTree t;
 shape s;
 register int n;
# endif
{
  if (t == NoTree) return;
  if (t->Kind == kBTE_LIST) {
  if (t->BTE_LIST.Elem->Kind == kSLICE_EXP) {
# line 359 "Shapes.puma"
  {
# line 360 "Shapes.puma"
 if (t->BTE_LIST.Elem->SLICE_EXP.START->Kind == kDUMMY_EXP)
        t->BTE_LIST.Elem->SLICE_EXP.START = s->bounds[n][0];
     if (t->BTE_LIST.Elem->SLICE_EXP.STOP->Kind == kDUMMY_EXP)
        t->BTE_LIST.Elem->SLICE_EXP.STOP = s->bounds[n][1];

# line 365 "Shapes.puma"
   MakeFullIndexShape (t->BTE_LIST.Next, s, n + 1);
  }
   return;

  }
# line 368 "Shapes.puma"
  {
# line 370 "Shapes.puma"
   MakeFullIndexShape (t->BTE_LIST.Next, s, n + 1);
  }
   return;

  }
  if (t->Kind == kBTE_EMPTY) {
# line 373 "Shapes.puma"
   return;

  }
;
}

bool IsWholeVar
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 393 "Shapes.puma"

struct_shape shp;
bool is;

  if (t->Kind == kUSED_VAR) {
# line 398 "Shapes.puma"
   return true;

  }
  if (t->Kind == kINDEXED_VAR) {
  if (t->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
# line 402 "Shapes.puma"
  {
# line 403 "Shapes.puma"
 GetCurrentShape (t, &shp);
     is = FullIndexSlices (t->INDEXED_VAR.IND_EXPS, &shp, 0);

  }
   return is;

  }
  }
# line 409 "Shapes.puma"
  {
# line 410 "Shapes.puma"
   failure_protocol ("Shapes", "IsWholeVar", t);
  }
   return false;

}

static bool FullIndexSlices
# if defined __STDC__ | defined __cplusplus
(register tTree t, shape s, register int n)
# else
(t, s, n)
 register tTree t;
 shape s;
 register int n;
# endif
{
# line 416 "Shapes.puma"

bool is;
int val;

  if (t == NoTree) return false;
  if (t->Kind == kBTE_LIST) {
  if (t->BTE_LIST.Elem->Kind == kSLICE_EXP) {
# line 421 "Shapes.puma"
  {
# line 425 "Shapes.puma"
   if (! (FullIndexSlice (t->BTE_LIST.Elem, s, n))) goto yyL1;
  {
# line 426 "Shapes.puma"
   if (! (FullIndexSlices (t->BTE_LIST.Next, s, n + 1))) goto yyL1;
  }
  }
   return true;
yyL1:;

  }
  }
  if (t->Kind == kBTE_EMPTY) {
# line 429 "Shapes.puma"
   return true;

  }
  return false;
}

static bool FullIndexSlice
# if defined __STDC__ | defined __cplusplus
(register tTree t, shape s, register int n)
# else
(t, s, n)
 register tTree t;
 shape s;
 register int n;
# endif
{
# line 434 "Shapes.puma"

bool is;
int val;

  if (t == NoTree) return false;
  if (t->Kind == kSLICE_EXP) {
# line 439 "Shapes.puma"
  {
# line 443 "Shapes.puma"
 is = true;

     if (t->SLICE_EXP.START->Kind != kDUMMY_EXP)
        is = EqualExpression (t->SLICE_EXP.START, s->bounds[n][0]);

     if (is  && (t->SLICE_EXP.STOP->Kind != kDUMMY_EXP) )
        is = EqualExpression (t->SLICE_EXP.STOP, s->bounds[n][1]);
     if (is)
        { SliceIncrement (t, &is, &val);
          if (is) is = (val == 1);
        }

# line 456 "Shapes.puma"
   if (! (is == true)) goto yyL1;
  }
   return true;
yyL1:;

  }
  return false;
}

static void PrintCompare
# if defined __STDC__ | defined __cplusplus
(register tTree e1, register tTree e2, register bool is)
# else
(e1, e2, is)
 register tTree e1;
 register tTree e2;
 register bool is;
# endif
{
  if (e1 == NoTree) return;
  if (e2 == NoTree) return;
# line 461 "Shapes.puma"
  {
# line 462 "Shapes.puma"
   printf ("Compare, e1 = ");
# line 462 "Shapes.puma"
   FileUnparse (stdout, e1);
# line 463 "Shapes.puma"
   printf (" e2 = ");
# line 463 "Shapes.puma"
   FileUnparse (stdout, e2);
# line 464 "Shapes.puma"
 if (is) printf (" are equal\n");
        else
             printf (" not equal\n");
  }
   return;

;
}

tTree NormalizeShape
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 480 "Shapes.puma"

tTree newvar;

  if (t->Kind == kUSED_VAR) {
# line 484 "Shapes.puma"
   return t;

  }
  if (t->Kind == kINDEXED_VAR) {
# line 488 "Shapes.puma"
  {
# line 489 "Shapes.puma"
 if (IsWholeVar(t))
       newvar = t->INDEXED_VAR.IND_VAR;
      else
       newvar = MakeFullShape (t);

  }
   return newvar;

  }
  if (t->Kind == kVAR_EXP) {
# line 497 "Shapes.puma"
  {
# line 498 "Shapes.puma"
 t->VAR_EXP.V = NormalizeShape (t->VAR_EXP.V);
  }
   return t;

  }
# line 502 "Shapes.puma"
   return t;

}

bool IsContiguousSection
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 522 "Shapes.puma"

struct_shape s;

  if (t == NoTree) return false;
  if (t->Kind == kUSED_VAR) {
# line 526 "Shapes.puma"
   return true;

  }
  if (t->Kind == kINDEXED_VAR) {
  if (t->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
# line 529 "Shapes.puma"
  {
# line 531 "Shapes.puma"
 GetCurrentShape (t, &s);
# line 532 "Shapes.puma"
   if (! (IsContiguousShape (t->INDEXED_VAR.IND_EXPS, & s, 0))) goto yyL2;
  }
   return true;
yyL2:;

  }
  }
  return false;
}

static bool IsContiguousShape
# if defined __STDC__ | defined __cplusplus
(register tTree t, shape s, register int n)
# else
(t, s, n)
 register tTree t;
 shape s;
 register int n;
# endif
{
# line 537 "Shapes.puma"

bool is;
int val;

  if (t == NoTree) return false;
  if (t->Kind == kBTE_EMPTY) {
# line 542 "Shapes.puma"
   return true;

  }
  if (t->Kind == kBTE_LIST) {
  if (t->BTE_LIST.Elem->Kind == kSLICE_EXP) {
# line 545 "Shapes.puma"
  {
# line 547 "Shapes.puma"
   if (! (FullIndexSlice (t->BTE_LIST.Elem, s, n))) goto yyL2;
  {
# line 548 "Shapes.puma"
   if (! (IsContiguousShape (t->BTE_LIST.Next, s, n + 1))) goto yyL2;
  }
  }
   return true;
yyL2:;

# line 551 "Shapes.puma"
  {
# line 553 "Shapes.puma"
   if (! (SingleIndexes (t->BTE_LIST.Next))) goto yyL3;
  {
# line 554 "Shapes.puma"
 SliceIncrement (t->BTE_LIST.Elem, &is, &val);
# line 555 "Shapes.puma"
   if (! (is)) goto yyL3;
  {
# line 556 "Shapes.puma"
   if (! (val == 1)) goto yyL3;
  }
  }
  }
   return true;
yyL3:;

  }
# line 559 "Shapes.puma"
  {
# line 560 "Shapes.puma"
   if (! (SingleIndexes (t->BTE_LIST.Next))) goto yyL4;
  }
   return true;
yyL4:;

  }
  return false;
}

static bool SingleIndexes
# if defined __STDC__ | defined __cplusplus
(register tTree indexes)
# else
(indexes)
 register tTree indexes;
# endif
{
  if (indexes == NoTree) return false;
  if (indexes->Kind == kBTE_EMPTY) {
# line 565 "Shapes.puma"
   return true;

  }
  if (indexes->Kind == kBTE_LIST) {
  if (indexes->BTE_LIST.Elem->Kind == kSLICE_EXP) {
# line 568 "Shapes.puma"
  {
# line 569 "Shapes.puma"
   return false;
  }

  }
# line 572 "Shapes.puma"
   return true;

  }
  return false;
}

void BeginShapes ()
{
}

void CloseShapes ()
{
}
