/* Registers suggested audio applications for AudioCenter */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'

call SysLoadFuncs

if length(stream(directory() || '\audiocen.ini', 'c', 'query exists')) > 0 then do
	say
	say 'The AudioCenter ini file already exists'
	if Question('Overwrite? (Y/N)') then
		call SysFileDelete directory() || '\audiocen.ini'
	else exit
end

Apps.0 = 0
Apps.!List = 'ULTITEXT.EXE' 'MUSE2TXT.EXE' 'DMP.EXE' 'MPG123.EXE' 'TIMIDITY.EXE'
Apps.!Ext = '*.MOD;*.S3M;*.MTM;*.XM;' '*.IT;*.FAR;*.STM;*.669;*.ULT;*.WOW;' '*.AMF;*.NST;' '*.MP2;*.MP3;' '*.MID;'
Apps.!Params = '/NOJ' '""' '""' '""' '""'

say
say 'Searching for the following applications'
say Apps.!List

Drives = SysDriveMap('C:', 'LOCAL')

do WordNo = 1 to words(Drives)

	CurrentDrive = word(Drives, WordNo)

	if length(SysDriveInfo(CurrentDrive)) > 0 then do

		Skip = 0

		if ReadOnly(CurrentDrive) then do
/*
			say 'This drive appears to be a readonly drive (CDROM)'
			Skip = Question('Skip drive ' || CurrentDrive || "? (Y/N)")
*/
			Skip = 1
		end

		if \ Skip then do

			say 'Searching ' || CurrentDrive || ' ...'

			if SysFileTree(CurrentDrive || '\*.exe', 'Files', 'FSO') = 0 then do
			do FileNo = 1 to Files.0
				if wordpos(Upper(filespec('NAME', Files.FileNo)), Apps.!List) > 0 then do
					Apps.0 = Apps.0 + 1
					call value 'Apps.'Apps.0, Upper(Files.FileNo)
				end
			end
			end

		end

	end

end

if Apps.0 > 0 then do

	Apps.!Reg = ''

	say
	say 'The following is a list of the audio applications found.'
	say

	do AppNo = 1 to Apps.0

		if wordpos(filespec('NAME', Apps.AppNo), Apps.!Reg) = 0 then do

			say Apps.AppNo

			ListNo = wordpos(filespec('NAME', Apps.AppNo), Apps.!List)

			if word(Apps.!Params, ListNo) = '""' then
				call Register words(Apps.!Reg) + 1, Apps.AppNo, word(Apps.!Ext, ListNo), ""
			else
				call Register words(Apps.!Reg) + 1, Apps.AppNo, word(Apps.!Ext, ListNo), word(Apps.!Params, ListNo)

			Apps.!Reg = Apps.!Reg filespec('NAME', Apps.AppNo)

		end

	end

end; else say 'There were no audio applications found.'

exit

ReadOnly: procedure

	parse arg Drive

	ReturnVal = 0

	Temp = SysTempFileName(Drive || "\?????.tmp")

	if length(Temp) > 0 then do

		call stream Temp, 'c', 'open write'

		if length(stream(Temp, 'c', 'query exists')) = 0 then
			ReturnVal = 1
		else do
			call stream temp, 'c', 'close'
			call SysFileDelete Temp
		end

	end

return ReturnVal

Question: procedure

	parse arg Message

	ReturnVal = 0

	Key = ""

	say Message

	do until left(Key, 1) = 'Y' | left(Key, 1) = 'N'
		if length(Key) > 0 then do
			call beep 262, 250
			say Message
		end
		Key = SysGetKey()
		parse upper var Key Key
		say
	end

	if left(Key, 1) = 'Y' then ReturnVal = 1

return ReturnVal

Register: procedure

	parse arg AppNo, AppFile, Extensions, Parameters

	INIFile = directory() || '\audiocen.ini'
	INIApp = 'Prog' || AppNo

	Path = filespec('DRIVE', AppFile) || filespec('PATH', AppFile)
	Path = Left(Path, length(Path) - 1)

	call SysIni INIFile, INIApp, 'Path', Path || D2C(0)
	call SysIni INIFile, INIApp, 'Program', filespec('NAME', AppFile) || D2C(0)
	call SysIni INIFile, INIApp, 'Extentions', Extensions || D2C(0)
	call SysIni INIFile, INIApp, 'Params', Parameters || D2C(0)
	call SysIni INIFile, INIApp, 'Options', D2C(0)

return

Upper: procedure

	parse upper arg UCase

return UCase