//
// $Header: D:/32bits/ext2-os2/fsd32/RCS/fs32_findnext.c,v 1.3 1997/03/15 17:39:51 Willm Exp Willm $
//

// 32 bits Linux ext2 file system driver for OS/2 WARP - Allows OS/2 to
// access your Linux ext2fs partitions as normal drive letters.
// Copyright (C) 1995, 1996, 1997  Matthieu WILLM (willm@ibm.net)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifdef __IBMC__
#pragma strings(readonly)
#endif


#define INCL_DOS
#define INCL_DOSERRORS
#define INCL_NOPMAPI
#include <os2.h>

#include <os2/types.h>
#include <os2/StackToFlat.h>
#include <linux/fs.h>
#include <os2/os2proto.h>
#include <os2/fsd32.h>
#include <os2/DevHlp32.h>
#include <os2/log.h>
#include <os2/trace.h>
#include <os2/errors.h>
#include <os2/volume.h>
#include <linux/fs_proto.h>
#include <linux/stat.h>
#include <os2/filefind.h>


/*
 * struct fs32_findnext_parms {
 *     unsigned short  flags;
 *     unsigned short  level;
 *     PTR16           pcMatch;
 *     unsigned short  cbData;
 *     PTR16           pData;
 *     PTR16           pfsfsd;
 *     PTR16           pfsfsi;
 * };
 */
int FS32ENTRY fs32_findnext(struct fs32_findnext_parms *parms) {
    struct super_block *p_volume;
    struct fsfsi32 *pfsfsi;
    struct fsfsd32 *pfsfsd;
    char           *pData;
    unsigned short *pcMatch;
    int             rc, rc2;
    char lock[12];
    ULONG PgCount;


    pfsfsi  = VDHQueryLin(parms->pfsfsi);
    pfsfsd  = VDHQueryLin(parms->pfsfsd);
    pcMatch = VDHQueryLin(parms->pcMatch);

    if (trace_FS_FINDNEXT) {
        kernel_printf("FS_FINDNEXT pre-invocation %s , match = %u , level = %u, flag = %u", ((p_hfind)pfsfsd)->pName, *pcMatch, parms->level, parms->flags);
    }

    rc = ERROR_INVALID_PARAMETER;

    if ((parms->flags == FF_NOPOS) ||
        (parms->flags == FF_GETPOS)) {

        if ((parms->level == FIL_STANDARD)    ||
            (parms->level == FIL_QUERYEASIZE) ||
            (parms->level == FIL_QUERYEASFROMLIST)) {

            if (*pcMatch != 0) {

                if ((rc = DevHlp32_VirtToLin(parms->pData, __StackToFlat(&pData))) == NO_ERROR) {
                    rc = DevHlp32_VMLock(VMDHL_LONG | VMDHL_VERIFY | VMDHL_WRITE, pData, parms->cbData, (void *)-1, __StackToFlat(lock), __StackToFlat(&PgCount));
                    if ((rc == NO_ERROR) || (rc == ERROR_NOBLOCK)) {

                        /*
                         * Do the actual search
                         */
                        rc = myfindnext(
                                        ((p_hfind)pfsfsd)->p_file->f_inode->i_sb,
                                        ((p_hfind)pfsfsd)->p_file,
                                        ((p_hfind)pfsfsd)->attr,
                                        pfsfsi,
                                        pfsfsd,
                                        pData,
                                        parms->cbData,
                                        pcMatch,
                                        parms->level,
                                        parms->flags,
                                        ((p_hfind)pfsfsd)->last,
                                        0,
                                        is_case_retensive()
                                       );

                        if ((rc2 = DevHlp32_VMUnlock(__StackToFlat(lock))) == NO_ERROR) {
                            /*
                             * Nothing else ...
                             */
                        } else {
                            rc = rc2;
                        }
                    } /* VMLock failed */
                } /* VirtToLin failed */
            } /* *pcMatch = 0 */
        } /* level is invalid */
    } /* flags are invalid */

    if (trace_FS_FINDNEXT) {
        kernel_printf("FS_FINDNEXT post-invocation %s , rc = %d", ((p_hfind)pfsfsd)->pName, rc);
    }

    return rc;
}
