//
// $Header: D:/32bits/ext2-os2/minifsd/RCS/files.c,v 9.1 1997/03/15 22:31:04 Willm Exp Willm $
//

// 32 bits Linux ext2 file system driver for OS/2 WARP - Allows OS/2 to
// access your Linux ext2fs partitions as normal drive letters.
// Copyright (C) 1995, 1996, 1997  Matthieu WILLM (willm@ibm.net)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.



#define INCL_DOSERRORS
#define INCL_NOPMAPI
#include <os2.h>		// From the "Developer Connection Device Driver Kit" version 2.0

#include <fsh.h>

#include <string.h>

#include <os2/types.h>
#include <os2/errors.h>

#include <linux/fs.h>
#include <linux/fs_proto.h>
#include <linux/e2_proto.h>
#include <os2/os2proto.h>
#include <os2/log.h>         /* Prototypes des fonctions de log.c                      */


//
// These routines will be eventually rewritten and splitted between ext2/namei.c
// (namei()), vfs/namei.c (dir_namei, open_namei, ....) and vfs/open.c (do_open ...)
//

struct file *_open_by_inode(struct super_block * p_volume, UINT32 ino_no, UINT32 openmode)
{
    struct file    *p_file;

//    printk("\topen_by_inode(%lu)", ino_no);

    /*******************************************************************/
    /*** Allocates a file descriptor                                 ***/
    /*******************************************************************/
    if ((p_file = get_empty_filp()) == 0) {
        printk("_open_by_inode : couldn't get an empty file descriptor");
        return 0;
    }
    /*******************************************************************/

    /*******************************************************************/
    /*** Gets the v-inode (if already exists) or allocates a new one ***/
    /*******************************************************************/
    if ((p_file->f_inode = iget(p_volume, ino_no)) == NULL) {
        printk("_open_by_inode : couldn't get inode %ld", ino_no);
        put_filp(p_file);
        return 0;
    }
    /*******************************************************************/




    p_file->f_pos            = 0;
    p_file->f_mode           = openmode;
    if (p_file->f_inode->i_op)
        p_file->f_op = p_file->f_inode->i_op->default_file_ops;

//    printk("\tend open_by_inode(%lu)", ino_no);
    return p_file;
}

int vfs_close(struct file *f)
{
    int           rc;

#ifdef FS_TRACE
    kernel_printf("close( %lu )", f->f_inode->i_ino);
#endif

    iput(f->f_inode);

    if ((rc = put_filp(f)) != NO_ERROR) {
        fs_err(FUNC_CLOSE, FUNC_FREE_HFILE, rc, FILE_FILES_C, __LINE__);
        return rc;
    }

    return NO_ERROR;
}






struct file *_open_by_name(struct super_block * p_volume, char *pName, UINT32 openmode)
{
    char         pNom[CCHMAXPATH];
    char        *pTmp;
    struct file *p_file;
    int          ok;
    int          Fin;
    int          FinPath;
    UINT32       ino_no;
    struct dirent          Dir;
    int          rc;


//    printk("\topen_by_name(%s)", pName);


    memset(pNom, '\0', CCHMAXPATH);

    pTmp = DecoupePath(pName, pNom);
    /*******************************************************************/
    /*** If it is the root directory we've finished                  ***/
    /*******************************************************************/
    if (pTmp == 0) {
        return _open_by_inode(p_volume, EXT2_ROOT_INO, openmode);
    }
    /*******************************************************************/

    /*******************************************************************/
    /*** We loop on the path components                              ***/
    /*******************************************************************/
    ino_no  = EXT2_ROOT_INO;
    FinPath = 0;
    while (FinPath == 0) {
        /*******************************************************************/
        /*** Opens the "." file of the directory                         ***/
        /*******************************************************************/
        if ((p_file = _open_by_inode(p_volume, ino_no, OPENMODE_READONLY)) == 0) {
            printk("open_by_name : open_by_inode failed for '.'");
            return 0;
        } /* end if */
        /*******************************************************************/

            ok = 0;
            Fin = 0;
            /*** Lookup inside the "." file of the parent directory ***/
            while (Fin == 0) {
                if (VFS_readdir(p_file, &Dir) != 0) {
                    Fin = 1;
                } else {
                    /*
                     * We do a case insensitive comparaison
                     */
                    if (stricmp(pNom, Dir.d_name) == 0) {
                        Fin = 1;
                        ok  = 1;
                    } /* end if */
                } /* end if */
            } /* end while */
            /*** si pas trouv on retourne 0 ***/
            if (ok == 0) {
                if ((rc = vfs_close(p_file)) != NO_ERROR) {
                    ext2_os2_panic(0, "open_by_name : 1st vfs_close failed");
                } /* end if */
               return 0;
            } /* end if */
            /*** If found we go down a level ***/
            ino_no = Dir.d_ino;
            if ((rc = vfs_close(p_file)) != NO_ERROR) {
                    ext2_os2_panic(0, "open_by_name : 2nd vfs_close failed");
            } /* end if */

        if ((pTmp = DecoupePath(pTmp, pNom)) == 0) {
            FinPath = 1;
        } /* end if */

    }
    /*******************************************************************/


    p_file = _open_by_inode(p_volume, ino_no, openmode);

//    printk("\tend open_by_name(%s)", pName);

    return p_file;
}

