/*
 * Copyright 2009 Vasilkin Andrew <digi@os2.snc.ru>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *    1. Redistributions of source code must retain the above copyright notice,
 *       this list of conditions and the following disclaimer.
 *
 *    2. Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *
 *    3. The name of the author may not be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef RESOURCE_H
#define RESOURCE_H

#include <lqlib.h>
#include <debug.h>

#define OPEN_EXISTING	OPEN_ACTION_FAIL_IF_NEW | OPEN_ACTION_OPEN_IF_EXISTS
#define OPEN_REPLACE	OPEN_ACTION_CREATE_IF_NEW | OPEN_ACTION_REPLACE_IF_EXISTS
#define OPEN_CREATE	OPEN_ACTION_CREATE_IF_NEW | OPEN_ACTION_FAIL_IF_EXISTS

typedef struct _RES	*PRES;

typedef BOOL FNLISTITEM(PFILEFINDBUF3L psFind, PVOID pFNData);
typedef FNLISTITEM *PFNLISTITEM;

ULONG resInit();
VOID resDone();
ULONG resNew(PSZ pszCfgFile, PRES *ppsRes);
VOID resFree(PRES psRes);
VOID resConnectionNew(PRES psRes);
VOID resConnectionFree(PRES psRes);
ULONG resCompare(PRES psRes, PRES psResTest);
ULONG resGetInfo(PRES psRes, PCHAR pcBuf, ULONG ulBufLen, PULONG pulActual,
                 PULONG pulMounPoints);
ULONG resQueryFSAllocate(PRES psRes, PULONG pulSectorUnit, PULONG pulUnit,
                         PULONG pulUnitAvail, PUSHORT pusSector);
ULONG resRefresh(PRES psRes, PSZ pszMountPointPath, BOOL fSubdir);
ULONG resFlush(PRES psRes);
ULONG resQueryPathInfo(PRES psRes, PSZ pszMountPointPath, PFILESTATUS3L psStat);
ULONG resSetPathInfo(PRES psRes, PSZ pszMountPointPath, PFILESTATUS3L psStat);
ULONG resDelete(PRES psRes, PSZ pszFile);
ULONG resCreateDir(PRES psRes, PSZ pszMountPointPath);
ULONG resDeleteDir(PRES psRes, PSZ pszMountPointPath);
ULONG resList(PRES psRes, PSZ pszMountPointPath, ULONG ulAttribute,
              PFNLISTITEM pfnListItem, PVOID pFNData);
ULONG resCopy(PRES psRes, PRES psResDst, PSZ pszFile, PSZ pszFileDest,
              ULONG ulOption);
ULONG resMove(PRES psRes, PRES psResDst, PSZ pszFile, PSZ pszFileDest);
ULONG resOpen(PRES psRes, PSZ pszFile, PHFILE phFile, LONGLONG llSize,
              ULONG ulAttribute, ULONG ulOpenFlags, ULONG ulOpenMode);
ULONG resFileClose(PRES psRes, HFILE hFile);
ULONG resSetFileAttribute(PRES psRes, PSZ pszFile, USHORT usAttr);
ULONG resFileQueryInfo(PRES psRes, HFILE hFile, PFILESTATUS3L psStat);
ULONG resFileSetInfo(PRES psRes, HFILE hFile, PFILESTATUS3L psStat);
ULONG resFileSetFilePtr(PRES psRes, HFILE hFile, LONGLONG llOffset,
                        ULONG ulMethod, LONGLONG *pllActual);
ULONG resFileNewSize(PRES psRes, HFILE hFile, LONGLONG llSize);
ULONG resFileRead(PRES psRes, HFILE hFile, PVOID pBuffer, ULONG ulLength,
                  ULONG *pulActual);
ULONG resFileWrite(PRES psRes, HFILE hFile, PVOID pBuffer, ULONG ulLength,
                   ULONG *pulActual);

#endif // RESOURCE_H
