/*

   Usage: copy this file into your MMOS2 folder and run it from there.

   by Marcel Mller, Aug. 2003

   mueller@maazl.de

*/

SAY "Patch for Aureal Vortex 1 driver for OS/2."
SAY "By Marcel Mller, Aug. 2003"
SAY
SAY "This will remove the restriction of the driver to PCI bus 0."

R = 0

IF Patch("ASP4CORE.SYS", "81C1000800004381F900000100731C"x, "81C1000800004381F900000001731C"x) > 10 THEN
   R = 1

IF Patch("ASP4OS2.SYS", "8146FC000883D7008346F2018356FA0083FF017320"x, "8046FD0883D7008346F2018356FA0081FF00017320"x) > 10 THEN
   R = 1

EXIT R


Patch: PROCEDURE
/* ARG(1) file
   ARG(2) search string
   ARG(3) replacement string
*/
   SAY
   SAY "Patching "ARG(1)" ..."
   /* read file */
   data = CHARIN(ARG(1),,99999999)
   CALL STREAM ARG(1), 'c', 'close'
   IF data = '' THEN DO
      SAY "- File not found in the current directory."
      RETURN 20
      END
   /* locate patch */
   p = POS(ARG(2), data)
   IF p = 0 THEN DO
      IF POS(ARG(3), data) = 0 THEN
         SAY "- Did not find signature in file. Maybe the file is of wrong version."
       ELSE
         SAY "- The file is already patched."
      RETURN 10
      END
   /* apply patch */
   data = OVERLAY(ARG(3), data, p)
   /* backup file */
   '@move 'ARG(1)' *.BAK >nul'
   IF RC \= 0 THEN
      SAY "- Failed to backup file."
   /* write file */
   IF CHAROUT(ARG(1), data, 1) \= 0 THEN DO
      SAY "- Failed to write file."
      RETURN 11
      END
   CALL STREAM ARG(1), 'c', 'close'
   /* done */
   SAY "- Driver patched successfully."
   RETURN 0

