* Weitek P9000 WIN

:TITLE
Weitek P9000 WINCFG DSP

:KEY
WEITEK_P9000WIN

:FILES :MODE=PRIMARY :MODE=WINDOWS
P9000          %WINPATH%
P9000SYS       %WINPATH%\SYSTEM\
FONTS          %WINPATH%\SYSTEM

:WININI :MODE=PRIMARY :MODE=WINDOWS
SYSTEM.INI
*
* Set the seamless windows driver.
*
boot sdisplay.drv sp9k_08.drv
boot.description sdisplay.drv "Power 9000 Seamless Driver Version 2.53"
*
* Set the Seamless P9000 specific entries
*
SP9000.DRV Font small
*
* Set the windows system fonts.
* fonts.drv is used by OS/2 Full-Pack.
*
boot fonts.fon vgasys.fon
*
* Set the full screen windows driver.
* display.drv is used by OS/2 Full-Pack.
*
boot display.drv p9000_08.drv
boot.description display.drv "Power 9000 Full Screen Driver Version 1.10"
*
* Set the P9000 specific entries
*
P9000.DRV Resolution 640x480
P9000.DRV Refresh 60Hz
P9000.DRV Font Small
P9000.DRV Cursors 32
P9000.DRV Palette Standard
P9000.DRV DevBits Off
P9000.OEM BusType DETECT
P9000.OEM DacType BT485
P9000.OEM MemSize 2
P9000.OEM CursorUpdate On
P9000.OEM Cursor Power
P9000.OEM Speed 33.00mHz
P9000.OEM Monitor Generic
P9000.OEM DefMode 1024x768x8

****************************************************************************
*
* From this point on is the modifications to be made to the OS2.INI file
* in order to support updating the WIN-OS/2 Full Screen and Seamless
* display drivers when using the OS/2 System Object to change the
* display resolution and/or color depth.
*
* Notes:
*  1) When this method is used, only one refresh rate per resolution will
*     be able to be set.
*
*  2) The OS/2 System Object normally refers to the various color depths
*     in terms of number of colors available rather than the number of
*     bits per pixel.  However, this is not good enough for the Power
*     9x00 driver because it is possible to run in either 24 Bpp mode
*     or 32 Bpp mode.  Each of these modes supports the same number of
*     colors however the frame buffer is organazied differently.  As a
*     result, when 24 Bpp modes are supported (i.e. on a Power 9100
*     board with an IBM RGB525 DAC) it is necessary to be able to
*     distinguish between these two different color depths in order to
*     update both the Full Screen and Seamless WIN-OS/2 drivers properly.
*     As a result of this minor oversight, instead of refering to the
*     display modes based on the number of colors available, the Power
*     9x00 drivers will refer to the number of Bits Per Pixel.
*
*  3) Since this file is used for Power 9000 driver installation, and since
*     the Power 9000 does not support more than 2 Mb of video memory and
*     also does not support 24 Bpp, entries for 24 Bpp modes and modes
*     requiring more than 2 Mb of video memory will not be added.  This
*     will cut down on the amount of fudd that gets written out to the
*     OS2.INI file.
*
****************************************************************************
:OS2INI :MODE=PRIMARY :MODE=WINDOWS
OS2.INI
PM_DISPLAYDRIVERS RESOLUTION_CHANGED 1

*
* Define all the possible display modes.
*
WIN_RES_640x480x8    WIN_RES_SET    WIN_RES_P9_0
WIN_RES_800x600x8    WIN_RES_SET    WIN_RES_P9_1
WIN_RES_1024x768x8   WIN_RES_SET    WIN_RES_P9_2
WIN_RES_1280x1024x8  WIN_RES_SET    WIN_RES_P9_3
WIN_RES_1600x1200x8  WIN_RES_SET    WIN_RES_P9_4
WIN_RES_640x480x16   WIN_RES_SET    WIN_RES_P9_5
WIN_RES_800x600x16   WIN_RES_SET    WIN_RES_P9_6
WIN_RES_1024x768x16  WIN_RES_SET    WIN_RES_P9_7
WIN_RES_640x480x32   WIN_RES_SET    WIN_RES_P9_8
WIN_RES_800x600x32   WIN_RES_SET    WIN_RES_P9_9
"Power 9000 Mode Info"     "BPP24"        "OFF"
WIN_RES_640x480x256        WIN_RES_SET    WIN_RES_P9_0
WIN_RES_800x600x256        WIN_RES_SET    WIN_RES_P9_1
WIN_RES_1024x768x256       WIN_RES_SET    WIN_RES_P9_2
WIN_RES_1280x1024x256      WIN_RES_SET    WIN_RES_P9_3
WIN_RES_1600x1200x256      WIN_RES_SET    WIN_RES_P9_4
WIN_RES_640x480x65536      WIN_RES_SET    WIN_RES_P9_5
WIN_RES_800x600x65536      WIN_RES_SET    WIN_RES_P9_6
WIN_RES_1024x768x65536     WIN_RES_SET    WIN_RES_P9_7
WIN_RES_640x480x16777216   WIN_RES_SET    WIN_RES_P9_8
WIN_RES_800x600x16777216   WIN_RES_SET    WIN_RES_P9_9

*
* Define modifications required for 640x480x8 60Hz.
* Note: Duplicate entries at the end of the list are required
*       in order to match the number of entries made during
*       Power 9100 installation!!!
*
WIN_RES_P9_0   1  "system.ini boot display.drv  p9000_08.drv"
WIN_RES_P9_0   2  "system.ini boot sdisplay.drv sp9k_08.drv"
WIN_RES_P9_0   3  "system.ini SP9000.DRV Font Small"
WIN_RES_P9_0   4  "system.ini P9000.DRV Resolution 640x480"
WIN_RES_P9_0   5  "system.ini P9000.DRV Refresh 60Hz"
WIN_RES_P9_0   6  "system.ini P9000.DRV Font Small"
WIN_RES_P9_0   7  "system.ini P9000.DRV Cursors 32"
WIN_RES_P9_0   8  "system.ini P9000.DRV Palette Standard"
WIN_RES_P9_0   9  "system.ini P9000.DRV DevBits Off"
WIN_RES_P9_0  10  "system.ini P9000.OEM BusType DETECT"
WIN_RES_P9_0  11  "system.ini P9000.OEM DacType BT485"
WIN_RES_P9_0  12  "system.ini P9000.OEM MemSize 2"
WIN_RES_P9_0  13  "system.ini P9000.OEM CursorUpdate On"
WIN_RES_P9_0  14  "system.ini P9000.OEM Cursor Power"
WIN_RES_P9_0  15  "system.ini P9000.OEM Speed 33.00mHz"
WIN_RES_P9_0  16  "system.ini P9000.OEM Monitor Generic"
WIN_RES_P9_0  17  "system.ini P9000.OEM DefMode 1024x768x8"
WIN_RES_P9_0  18  "p9000res.ini 640x480x8 link 640x480"
WIN_RES_P9_0  19  "p9000res.ini 640x480 hdr 25.17mHz"
WIN_RES_P9_0  20  "p9000res.ini 640x480 hsp 96"
WIN_RES_P9_0  21  "p9000res.ini 640x480 hbp 32"
WIN_RES_P9_0  22  "p9000res.ini 640x480 had 640"
WIN_RES_P9_0  23  "p9000res.ini 640x480 hfp 32"
WIN_RES_P9_0  24  "p9000res.ini 640x480 hco 0"
WIN_RES_P9_0  25  "p9000res.ini 640x480 hp  negative"
WIN_RES_P9_0  26  "p9000res.ini 640x480 vlr 60Hz"
WIN_RES_P9_0  27  "p9000res.ini 640x480 vsp 4"
WIN_RES_P9_0  28  "p9000res.ini 640x480 vbp 24"
WIN_RES_P9_0  29  "p9000res.ini 640x480 vad 480"
WIN_RES_P9_0  30  "p9000res.ini 640x480 vfp 17"
WIN_RES_P9_0  31  "p9000res.ini 640x480 vco 0"
WIN_RES_P9_0  32  "p9000res.ini 640x480 vp  negative"
WIN_RES_P9_0  33  "p9000res.ini 640x480 vp  negative"
WIN_RES_P9_0  34  "p9000res.ini 640x480 vp  negative"
WIN_RES_P9_0  35  "p9000res.ini 640x480 vp  negative"
WIN_RES_P9_0  36  "p9000res.ini 640x480 vp  negative"
WIN_RES_P9_0  37  "p9000res.ini 640x480 vp  negative"
WIN_RES_P9_0  38  "p9000res.ini 640x480 vp  negative"
WIN_RES_P9_0  39  "p9000res.ini 640x480 vp  negative"
WIN_RES_P9_0  40  "p9000res.ini 640x480 vp  negative"
WIN_RES_P9_0  41  "system.ini boot fonts.fon vgasys.fon"

*
* Define modifications required for 800x600x8 60Hz.
* Note: Duplicate entries at the end of the list are required
*       in order to match the number of entries made during
*       Power 9100 installation!!!
*
WIN_RES_P9_1   1  "system.ini boot display.drv  p9000_08.drv"
WIN_RES_P9_1   2  "system.ini boot sdisplay.drv sp9k_08.drv"
WIN_RES_P9_1   3  "system.ini SP9000.DRV Font Small"
WIN_RES_P9_1   4  "system.ini P9000.DRV Resolution 800x600"
WIN_RES_P9_1   5  "system.ini P9000.DRV Refresh 60Hz"
WIN_RES_P9_1   6  "system.ini P9000.DRV Font Small"
WIN_RES_P9_1   7  "system.ini P9000.DRV Cursors 32"
WIN_RES_P9_1   8  "system.ini P9000.DRV Palette Standard"
WIN_RES_P9_1   9  "system.ini P9000.DRV DevBits Off"
WIN_RES_P9_1  10  "system.ini P9000.OEM BusType DETECT"
WIN_RES_P9_1  11  "system.ini P9000.OEM DacType BT485"
WIN_RES_P9_1  12  "system.ini P9000.OEM MemSize 2"
WIN_RES_P9_1  13  "system.ini P9000.OEM CursorUpdate On"
WIN_RES_P9_1  14  "system.ini P9000.OEM Cursor Power"
WIN_RES_P9_1  15  "system.ini P9000.OEM Speed 33.00mHz"
WIN_RES_P9_1  16  "system.ini P9000.OEM Monitor Generic"
WIN_RES_P9_1  17  "system.ini P9000.OEM DefMode 1024x768x8"
WIN_RES_P9_1  18  "p9000res.ini 800x600x8 link 800x600"
WIN_RES_P9_1  19  "p9000res.ini 800x600 hdr 40mHz"
WIN_RES_P9_1  20  "p9000res.ini 800x600 hsp 128"
WIN_RES_P9_1  21  "p9000res.ini 800x600 hbp 88"
WIN_RES_P9_1  22  "p9000res.ini 800x600 had 800"  
WIN_RES_P9_1  23  "p9000res.ini 800x600 hfp 40"
WIN_RES_P9_1  24  "p9000res.ini 800x600 hco 192"  
WIN_RES_P9_1  25  "p9000res.ini 800x600 hp  positive"
WIN_RES_P9_1  26  "p9000res.ini 800x600 vlr 60Hz"
WIN_RES_P9_1  27  "p9000res.ini 800x600 vsp 4"
WIN_RES_P9_1  28  "p9000res.ini 800x600 vbp 23"
WIN_RES_P9_1  29  "p9000res.ini 800x600 vad 600" 
WIN_RES_P9_1  30  "p9000res.ini 800x600 vfp 1"
WIN_RES_P9_1  31  "p9000res.ini 800x600 vco 22"  
WIN_RES_P9_1  32  "p9000res.ini 800x600 vp  positive"
WIN_RES_P9_1  33  "p9000res.ini 800x600 vp  positive"
WIN_RES_P9_1  34  "p9000res.ini 800x600 vp  positive"
WIN_RES_P9_1  35  "p9000res.ini 800x600 vp  positive"
WIN_RES_P9_1  36  "p9000res.ini 800x600 vp  positive"
WIN_RES_P9_1  37  "p9000res.ini 800x600 vp  positive"
WIN_RES_P9_1  38  "p9000res.ini 800x600 vp  positive"
WIN_RES_P9_1  39  "p9000res.ini 800x600 vp  positive"
WIN_RES_P9_1  40  "p9000res.ini 800x600 vp  positive"
WIN_RES_P9_1  41  "system.ini boot fonts.fon vgasys.fon"

*
* Define modifications required for 1024x768x8 60Hz.
* Note: Duplicate entries at the end of the list are required
*       in order to match the number of entries made during
*       Power 9100 installation!!!
*
WIN_RES_P9_2   1  "system.ini boot display.drv  p9000_08.drv"
WIN_RES_P9_2   2  "system.ini boot sdisplay.drv sp9k_08.drv"
WIN_RES_P9_2   3  "system.ini SP9000.DRV Font Large"
WIN_RES_P9_2   4  "system.ini P9000.DRV Resolution 1024x768"
WIN_RES_P9_2   5  "system.ini P9000.DRV Refresh 60Hz"
WIN_RES_P9_2   6  "system.ini P9000.DRV Font Large"
WIN_RES_P9_2   7  "system.ini P9000.DRV Cursors 32"
WIN_RES_P9_2   8  "system.ini P9000.DRV Palette Standard"
WIN_RES_P9_2   9  "system.ini P9000.DRV DevBits Off"
WIN_RES_P9_2  10  "system.ini P9000.OEM BusType DETECT"
WIN_RES_P9_2  11  "system.ini P9000.OEM DacType BT485"
WIN_RES_P9_2  12  "system.ini P9000.OEM MemSize 2"
WIN_RES_P9_2  13  "system.ini P9000.OEM CursorUpdate On"
WIN_RES_P9_2  14  "system.ini P9000.OEM Cursor Power"
WIN_RES_P9_2  15  "system.ini P9000.OEM Speed 33.00mHz"
WIN_RES_P9_2  16  "system.ini P9000.OEM Monitor Generic"
WIN_RES_P9_2  17  "system.ini P9000.OEM DefMode 1024x768x8"
WIN_RES_P9_2  18  "p9000res.ini 1024x768x8 link 1024x768"
WIN_RES_P9_2  19  "p9000res.ini 1024x768 hdr 65mHz"
WIN_RES_P9_2  20  "p9000res.ini 1024x768 hsp 136"
WIN_RES_P9_2  21  "p9000res.ini 1024x768 hbp 160"
WIN_RES_P9_2  22  "p9000res.ini 1024x768 had 1024" 
WIN_RES_P9_2  23  "p9000res.ini 1024x768 hfp 24"
WIN_RES_P9_2  24  "p9000res.ini 1024x768 hco 272" 
WIN_RES_P9_2  25  "p9000res.ini 1024x768 hp  negative"
WIN_RES_P9_2  26  "p9000res.ini 1024x768 vlr 60Hz"
WIN_RES_P9_2  27  "p9000res.ini 1024x768 vsp 6"
WIN_RES_P9_2  28  "p9000res.ini 1024x768 vbp 29"
WIN_RES_P9_2  29  "p9000res.ini 1024x768 vad 768" 
WIN_RES_P9_2  30  "p9000res.ini 1024x768 vfp 3"
WIN_RES_P9_2  31  "p9000res.ini 1024x768 vco 30" 
WIN_RES_P9_2  32  "p9000res.ini 1024x768 vp  negative"
WIN_RES_P9_2  33  "p9000res.ini 1024x768 vp  negative"
WIN_RES_P9_2  34  "p9000res.ini 1024x768 vp  negative"
WIN_RES_P9_2  35  "p9000res.ini 1024x768 vp  negative"
WIN_RES_P9_2  36  "p9000res.ini 1024x768 vp  negative"
WIN_RES_P9_2  37  "p9000res.ini 1024x768 vp  negative"
WIN_RES_P9_2  38  "p9000res.ini 1024x768 vp  negative"
WIN_RES_P9_2  39  "p9000res.ini 1024x768 vp  negative"
WIN_RES_P9_2  40  "p9000res.ini 1024x768 vp  negative"
WIN_RES_P9_2  41  "system.ini boot fonts.fon 8514sys.fon"

*
* Define modifications required for 1280x1024x8 60Hz.
* Note: Duplicate entries at the end of the list are required
*       in order to match the number of entries made during
*       Power 9100 installation!!!
*
WIN_RES_P9_3   1  "system.ini boot display.drv  p9000_08.drv"
WIN_RES_P9_3   2  "system.ini boot sdisplay.drv sp9k_08.drv"
WIN_RES_P9_3   3  "system.ini SP9000.DRV Font Large"
WIN_RES_P9_3   4  "system.ini P9000.DRV Resolution 1280x1024"
WIN_RES_P9_3   5  "system.ini P9000.DRV Refresh 60Hz"
WIN_RES_P9_3   6  "system.ini P9000.DRV Font Large"
WIN_RES_P9_3   7  "system.ini P9000.DRV Cursors 32"
WIN_RES_P9_3   8  "system.ini P9000.DRV Palette Standard"
WIN_RES_P9_3   9  "system.ini P9000.DRV DevBits Off"
WIN_RES_P9_3  10  "system.ini P9000.OEM BusType DETECT"
WIN_RES_P9_3  11  "system.ini P9000.OEM DacType BT485"
WIN_RES_P9_3  12  "system.ini P9000.OEM MemSize 2"
WIN_RES_P9_3  13  "system.ini P9000.OEM CursorUpdate On"
WIN_RES_P9_3  14  "system.ini P9000.OEM Cursor Power"
WIN_RES_P9_3  15  "system.ini P9000.OEM Speed 33.00mHz"
WIN_RES_P9_3  16  "system.ini P9000.OEM Monitor Generic"
WIN_RES_P9_3  17  "system.ini P9000.OEM DefMode 1024x768x8"
WIN_RES_P9_3  18  "p9000res.ini 1280x1024x8 link 1280x1024"
WIN_RES_P9_3  19  "p9000res.ini 1280x1024 hdr 115mHz"
WIN_RES_P9_3  20  "p9000res.ini 1280x1024 hsp 224"
WIN_RES_P9_3  21  "p9000res.ini 1280x1024 hbp 256"
WIN_RES_P9_3  22  "p9000res.ini 1280x1024 had 1280" 
WIN_RES_P9_3  23  "p9000res.ini 1280x1024 hfp 32"
WIN_RES_P9_3  24  "p9000res.ini 1280x1024 hco 456" 
WIN_RES_P9_3  25  "p9000res.ini 1280x1024 hp  positive"
WIN_RES_P9_3  26  "p9000res.ini 1280x1024 vlr 60Hz"
WIN_RES_P9_3  27  "p9000res.ini 1280x1024 vsp 3"
WIN_RES_P9_3  28  "p9000res.ini 1280x1024 vbp 42"
WIN_RES_P9_3  29  "p9000res.ini 1280x1024 vad 1024" 
WIN_RES_P9_3  30  "p9000res.ini 1280x1024 vfp 1"
WIN_RES_P9_3  31  "p9000res.ini 1280x1024 vco 41" 
WIN_RES_P9_3  32  "p9000res.ini 1280x1024 vp  positive"
WIN_RES_P9_3  33  "p9000res.ini 1280x1024 vp  positive"
WIN_RES_P9_3  34  "p9000res.ini 1280x1024 vp  positive"
WIN_RES_P9_3  35  "p9000res.ini 1280x1024 vp  positive"
WIN_RES_P9_3  36  "p9000res.ini 1280x1024 vp  positive"
WIN_RES_P9_3  37  "p9000res.ini 1280x1024 vp  positive"
WIN_RES_P9_3  38  "p9000res.ini 1280x1024 vp  positive"
WIN_RES_P9_3  39  "p9000res.ini 1280x1024 vp  positive"
WIN_RES_P9_3  40  "p9000res.ini 1280x1024 vp  positive"
WIN_RES_P9_3  41  "system.ini boot fonts.fon 8514sys.fon"

*
* Define modifications required for 1600x1200x8 60Hz.
* Note: Duplicate entries at the end of the list are required
*       in order to match the number of entries made during
*       Power 9100 installation!!!
*
WIN_RES_P9_4   1  "system.ini boot display.drv  p9000_08.drv"
WIN_RES_P9_4   2  "system.ini boot sdisplay.drv sp9k_08.drv"
WIN_RES_P9_4   3  "system.ini SP9000.DRV Font Large"
WIN_RES_P9_4   4  "system.ini P9000.DRV Resolution 1600x1200"
WIN_RES_P9_4   5  "system.ini P9000.DRV Refresh 60Hz"
WIN_RES_P9_4   6  "system.ini P9000.DRV Font Large"
WIN_RES_P9_4   7  "system.ini P9000.DRV Cursors 32"
WIN_RES_P9_4   8  "system.ini P9000.DRV Palette Standard"
WIN_RES_P9_4   9  "system.ini P9000.DRV DevBits Off"
WIN_RES_P9_4  10  "system.ini P9000.OEM BusType DETECT"
WIN_RES_P9_4  11  "system.ini P9000.OEM DacType BT485"
WIN_RES_P9_4  12  "system.ini P9000.OEM MemSize 2"
WIN_RES_P9_4  13  "system.ini P9000.OEM CursorUpdate On"
WIN_RES_P9_4  14  "system.ini P9000.OEM Cursor Power"
WIN_RES_P9_4  15  "system.ini P9000.OEM Speed 33.00mHz"
WIN_RES_P9_4  16  "system.ini P9000.OEM Monitor Generic"
WIN_RES_P9_4  17  "system.ini P9000.OEM DefMode 1024x768x8"
WIN_RES_P9_4  18  "p9000res.ini 1600x1200x8 link 1600x1200"
WIN_RES_P9_4  19  "p9000res.ini 1600x1200 hdr 160mHz"
WIN_RES_P9_4  20  "p9000res.ini 1600x1200 hsp 144"
WIN_RES_P9_4  21  "p9000res.ini 1600x1200 hbp 272"
WIN_RES_P9_4  22  "p9000res.ini 1600x1200 had 1600" 
WIN_RES_P9_4  23  "p9000res.ini 1600x1200 hfp 32"
WIN_RES_P9_4  24  "p9000res.ini 1600x1200 hco 0" 
WIN_RES_P9_4  25  "p9000res.ini 1600x1200 hp  negative"
WIN_RES_P9_4  26  "p9000res.ini 1600x1200 vlr 60Hz"
WIN_RES_P9_4  27  "p9000res.ini 1600x1200 vsp 8"
WIN_RES_P9_4  28  "p9000res.ini 1600x1200 vbp 49"
WIN_RES_P9_4  29  "p9000res.ini 1600x1200 vad 1200" 
WIN_RES_P9_4  30  "p9000res.ini 1600x1200 vfp 4"
WIN_RES_P9_4  31  "p9000res.ini 1600x1200 vco 0" 
WIN_RES_P9_4  32  "p9000res.ini 1600x1200 vp  negative"
WIN_RES_P9_4  33  "p9000res.ini 1600x1200 vp  negative"
WIN_RES_P9_4  34  "p9000res.ini 1600x1200 vp  negative"
WIN_RES_P9_4  35  "p9000res.ini 1600x1200 vp  negative"
WIN_RES_P9_4  36  "p9000res.ini 1600x1200 vp  negative"
WIN_RES_P9_4  37  "p9000res.ini 1600x1200 vp  negative"
WIN_RES_P9_4  38  "p9000res.ini 1600x1200 vp  negative"
WIN_RES_P9_4  39  "p9000res.ini 1600x1200 vp  negative"
WIN_RES_P9_4  40  "p9000res.ini 1600x1200 vp  negative"
WIN_RES_P9_4  41  "system.ini boot fonts.fon 8514sys.fon"

*
* Define modifications required for 640x480x16 60Hz.
* Note: Duplicate entries at the end of the list are required
*       in order to match the number of entries made during
*       Power 9100 installation!!!
*
WIN_RES_P9_5   1  "system.ini boot display.drv  p9000_16.drv"
WIN_RES_P9_5   2  "system.ini boot sdisplay.drv sp9k_16.drv"
WIN_RES_P9_5   3  "system.ini SP9000.DRV Font Small"
WIN_RES_P9_5   4  "system.ini P9000.DRV Resolution 640x480"
WIN_RES_P9_5   5  "system.ini P9000.DRV Refresh 60Hz"
WIN_RES_P9_5   6  "system.ini P9000.DRV Font Small"
WIN_RES_P9_5   7  "system.ini P9000.DRV Cursors 32"
WIN_RES_P9_5   8  "system.ini P9000.DRV Palette Standard"
WIN_RES_P9_5   9  "system.ini P9000.DRV DevBits Off"
WIN_RES_P9_5  10  "system.ini P9000.OEM BusType DETECT"
WIN_RES_P9_5  11  "system.ini P9000.OEM DacType BT485"
WIN_RES_P9_5  12  "system.ini P9000.OEM MemSize 2"
WIN_RES_P9_5  13  "system.ini P9000.OEM CursorUpdate On"
WIN_RES_P9_5  14  "system.ini P9000.OEM Cursor Power"
WIN_RES_P9_5  15  "system.ini P9000.OEM Speed 33.00mHz"
WIN_RES_P9_5  16  "system.ini P9000.OEM Monitor Generic"
WIN_RES_P9_5  17  "system.ini P9000.OEM DefMode 1024x768x8"
WIN_RES_P9_5  18  "p9000res.ini 640x480x16 link 640x480"
WIN_RES_P9_5  19  "p9000res.ini 640x480 hdr 25.17mHz"
WIN_RES_P9_5  20  "p9000res.ini 640x480 hsp 96"
WIN_RES_P9_5  21  "p9000res.ini 640x480 hbp 32"
WIN_RES_P9_5  22  "p9000res.ini 640x480 had 640"
WIN_RES_P9_5  23  "p9000res.ini 640x480 hfp 32"
WIN_RES_P9_5  24  "p9000res.ini 640x480 hco 0"
WIN_RES_P9_5  25  "p9000res.ini 640x480 hp  negative"
WIN_RES_P9_5  26  "p9000res.ini 640x480 vlr 60Hz"
WIN_RES_P9_5  27  "p9000res.ini 640x480 vsp 4"
WIN_RES_P9_5  28  "p9000res.ini 640x480 vbp 24"
WIN_RES_P9_5  29  "p9000res.ini 640x480 vad 480"
WIN_RES_P9_5  30  "p9000res.ini 640x480 vfp 17"
WIN_RES_P9_5  31  "p9000res.ini 640x480 vco 0"
WIN_RES_P9_5  32  "p9000res.ini 640x480 vp  negative"
WIN_RES_P9_5  33  "p9000res.ini 640x480 vp  negative"
WIN_RES_P9_5  34  "p9000res.ini 640x480 vp  negative"
WIN_RES_P9_5  35  "p9000res.ini 640x480 vp  negative"
WIN_RES_P9_5  36  "p9000res.ini 640x480 vp  negative"
WIN_RES_P9_5  37  "p9000res.ini 640x480 vp  negative"
WIN_RES_P9_5  38  "p9000res.ini 640x480 vp  negative"
WIN_RES_P9_5  39  "p9000res.ini 640x480 vp  negative"
WIN_RES_P9_5  40  "p9000res.ini 640x480 vp  negative"
WIN_RES_P9_5  41  "system.ini boot fonts.fon vgasys.fon"

*
* Define modifications required for 800x600x16 60Hz.
* Note: Duplicate entries at the end of the list are required
*       in order to match the number of entries made during
*       Power 9100 installation!!!
*
WIN_RES_P9_6   1  "system.ini boot display.drv  p9000_16.drv"
WIN_RES_P9_6   2  "system.ini boot sdisplay.drv sp9k_16.drv"
WIN_RES_P9_6   3  "system.ini SP9000.DRV Font Small"
WIN_RES_P9_6   4  "system.ini P9000.DRV Resolution 800x600"
WIN_RES_P9_6   5  "system.ini P9000.DRV Refresh 60Hz"
WIN_RES_P9_6   6  "system.ini P9000.DRV Font Small"
WIN_RES_P9_6   7  "system.ini P9000.DRV Cursors 32"
WIN_RES_P9_6   8  "system.ini P9000.DRV Palette Standard"
WIN_RES_P9_6   9  "system.ini P9000.DRV DevBits Off"
WIN_RES_P9_6  10  "system.ini P9000.OEM BusType DETECT"
WIN_RES_P9_6  11  "system.ini P9000.OEM DacType BT485"
WIN_RES_P9_6  12  "system.ini P9000.OEM MemSize 2"
WIN_RES_P9_6  13  "system.ini P9000.OEM CursorUpdate On"
WIN_RES_P9_6  14  "system.ini P9000.OEM Cursor Power"
WIN_RES_P9_6  15  "system.ini P9000.OEM Speed 33.00mHz"
WIN_RES_P9_6  16  "system.ini P9000.OEM Monitor Generic"
WIN_RES_P9_6  17  "system.ini P9000.OEM DefMode 1024x768x8"
WIN_RES_P9_6  18  "p9000res.ini 800x600x16 link 800x600"
WIN_RES_P9_6  19  "p9000res.ini 800x600 hdr 40mHz"
WIN_RES_P9_6  20  "p9000res.ini 800x600 hsp 128"
WIN_RES_P9_6  21  "p9000res.ini 800x600 hbp 88"
WIN_RES_P9_6  22  "p9000res.ini 800x600 had 800"  
WIN_RES_P9_6  23  "p9000res.ini 800x600 hfp 40"
WIN_RES_P9_6  24  "p9000res.ini 800x600 hco 192"  
WIN_RES_P9_6  25  "p9000res.ini 800x600 hp  positive"
WIN_RES_P9_6  26  "p9000res.ini 800x600 vlr 60Hz"
WIN_RES_P9_6  27  "p9000res.ini 800x600 vsp 4"
WIN_RES_P9_6  28  "p9000res.ini 800x600 vbp 23"
WIN_RES_P9_6  29  "p9000res.ini 800x600 vad 600" 
WIN_RES_P9_6  30  "p9000res.ini 800x600 vfp 1"
WIN_RES_P9_6  31  "p9000res.ini 800x600 vco 22"  
WIN_RES_P9_6  32  "p9000res.ini 800x600 vp  positive"
WIN_RES_P9_6  33  "p9000res.ini 800x600 vp  positive"
WIN_RES_P9_6  34  "p9000res.ini 800x600 vp  positive"
WIN_RES_P9_6  35  "p9000res.ini 800x600 vp  positive"
WIN_RES_P9_6  36  "p9000res.ini 800x600 vp  positive"
WIN_RES_P9_6  37  "p9000res.ini 800x600 vp  positive"
WIN_RES_P9_6  38  "p9000res.ini 800x600 vp  positive"
WIN_RES_P9_6  39  "p9000res.ini 800x600 vp  positive"
WIN_RES_P9_6  40  "p9000res.ini 800x600 vp  positive"
WIN_RES_P9_6  41  "system.ini boot fonts.fon vgasys.fon"

*
* Define modifications required for 1024x768x16 60Hz.
* Note: Duplicate entries at the end of the list are required
*       in order to match the number of entries made during
*       Power 9100 installation!!!
*
WIN_RES_P9_7   1  "system.ini boot display.drv  p9000_16.drv"
WIN_RES_P9_7   2  "system.ini boot sdisplay.drv sp9k_16.drv"
WIN_RES_P9_7   3  "system.ini SP9000.DRV Font Large"
WIN_RES_P9_7   4  "system.ini P9000.DRV Resolution 1024x768"
WIN_RES_P9_7   5  "system.ini P9000.DRV Refresh 60Hz"
WIN_RES_P9_7   6  "system.ini P9000.DRV Font Large"
WIN_RES_P9_7   7  "system.ini P9000.DRV Cursors 32"
WIN_RES_P9_7   8  "system.ini P9000.DRV Palette Standard"
WIN_RES_P9_7   9  "system.ini P9000.DRV DevBits Off"
WIN_RES_P9_7  10  "system.ini P9000.OEM BusType DETECT"
WIN_RES_P9_7  11  "system.ini P9000.OEM DacType BT485"
WIN_RES_P9_7  12  "system.ini P9000.OEM MemSize 2"
WIN_RES_P9_7  13  "system.ini P9000.OEM CursorUpdate On"
WIN_RES_P9_7  14  "system.ini P9000.OEM Cursor Power"
WIN_RES_P9_7  15  "system.ini P9000.OEM Speed 33.00mHz"
WIN_RES_P9_7  16  "system.ini P9000.OEM Monitor Generic"
WIN_RES_P9_7  17  "system.ini P9000.OEM DefMode 1024x768x8"
WIN_RES_P9_7  18  "p9000res.ini 1024x768x16 link 1024x768"
WIN_RES_P9_7  19  "p9000res.ini 1024x768 hdr 65mHz"
WIN_RES_P9_7  20  "p9000res.ini 1024x768 hsp 136"
WIN_RES_P9_7  21  "p9000res.ini 1024x768 hbp 160"
WIN_RES_P9_7  22  "p9000res.ini 1024x768 had 1024" 
WIN_RES_P9_7  23  "p9000res.ini 1024x768 hfp 24"
WIN_RES_P9_7  24  "p9000res.ini 1024x768 hco 272" 
WIN_RES_P9_7  25  "p9000res.ini 1024x768 hp  negative"
WIN_RES_P9_7  26  "p9000res.ini 1024x768 vlr 60Hz"
WIN_RES_P9_7  27  "p9000res.ini 1024x768 vsp 6"
WIN_RES_P9_7  28  "p9000res.ini 1024x768 vbp 29"
WIN_RES_P9_7  29  "p9000res.ini 1024x768 vad 768" 
WIN_RES_P9_7  30  "p9000res.ini 1024x768 vfp 3"
WIN_RES_P9_7  31  "p9000res.ini 1024x768 vco 30" 
WIN_RES_P9_7  32  "p9000res.ini 1024x768 vp  negative"
WIN_RES_P9_7  33  "p9000res.ini 1024x768 vp  negative"
WIN_RES_P9_7  34  "p9000res.ini 1024x768 vp  negative"
WIN_RES_P9_7  35  "p9000res.ini 1024x768 vp  negative"
WIN_RES_P9_7  36  "p9000res.ini 1024x768 vp  negative"
WIN_RES_P9_7  37  "p9000res.ini 1024x768 vp  negative"
WIN_RES_P9_7  38  "p9000res.ini 1024x768 vp  negative"
WIN_RES_P9_7  39  "p9000res.ini 1024x768 vp  negative"
WIN_RES_P9_7  40  "p9000res.ini 1024x768 vp  negative"
WIN_RES_P9_7  41  "system.ini boot fonts.fon 8514sys.fon"

*
* Define modifications required for 640x480x32 60Hz.
* Note: Duplicate entries at the end of the list are required
*       in order to match the number of entries made during
*       Power 9100 installation!!!
*
WIN_RES_P9_8   1  "system.ini boot display.drv  p9000_32.drv"
WIN_RES_P9_8   2  "system.ini boot sdisplay.drv sp9k_32.drv"
WIN_RES_P9_8   3  "system.ini SP9000.DRV Font Small"
WIN_RES_P9_8   4  "system.ini P9000.DRV Resolution 640x480"
WIN_RES_P9_8   5  "system.ini P9000.DRV Refresh 60Hz"
WIN_RES_P9_8   6  "system.ini P9000.DRV Font Small"
WIN_RES_P9_8   7  "system.ini P9000.DRV Cursors 32"
WIN_RES_P9_8   8  "system.ini P9000.DRV Palette Standard"
WIN_RES_P9_8   9  "system.ini P9000.DRV DevBits Off"
WIN_RES_P9_8  10  "system.ini P9000.OEM BusType DETECT"
WIN_RES_P9_8  11  "system.ini P9000.OEM DacType BT485"
WIN_RES_P9_8  12  "system.ini P9000.OEM MemSize 2"
WIN_RES_P9_8  13  "system.ini P9000.OEM CursorUpdate On"
WIN_RES_P9_8  14  "system.ini P9000.OEM Cursor Power"
WIN_RES_P9_8  15  "system.ini P9000.OEM Speed 33.00mHz"
WIN_RES_P9_8  16  "system.ini P9000.OEM Monitor Generic"
WIN_RES_P9_8  17  "system.ini P9000.OEM DefMode 1024x768x8"
WIN_RES_P9_8  18  "p9000res.ini 640x480x32 link 640x480"
WIN_RES_P9_8  19  "p9000res.ini 640x480 hdr 25.17mHz"
WIN_RES_P9_8  20  "p9000res.ini 640x480 hsp 96"
WIN_RES_P9_8  21  "p9000res.ini 640x480 hbp 32"
WIN_RES_P9_8  22  "p9000res.ini 640x480 had 640"
WIN_RES_P9_8  23  "p9000res.ini 640x480 hfp 32"
WIN_RES_P9_8  24  "p9000res.ini 640x480 hco 0"
WIN_RES_P9_8  25  "p9000res.ini 640x480 hp  negative"
WIN_RES_P9_8  26  "p9000res.ini 640x480 vlr 60Hz"
WIN_RES_P9_8  27  "p9000res.ini 640x480 vsp 4"
WIN_RES_P9_8  28  "p9000res.ini 640x480 vbp 24"
WIN_RES_P9_8  29  "p9000res.ini 640x480 vad 480"
WIN_RES_P9_8  30  "p9000res.ini 640x480 vfp 17"
WIN_RES_P9_8  31  "p9000res.ini 640x480 vco 0"
WIN_RES_P9_8  32  "p9000res.ini 640x480 vp  negative"
WIN_RES_P9_8  33  "p9000res.ini 640x480 vp  negative"
WIN_RES_P9_8  34  "p9000res.ini 640x480 vp  negative"
WIN_RES_P9_8  35  "p9000res.ini 640x480 vp  negative"
WIN_RES_P9_8  36  "p9000res.ini 640x480 vp  negative"
WIN_RES_P9_8  37  "p9000res.ini 640x480 vp  negative"
WIN_RES_P9_8  38  "p9000res.ini 640x480 vp  negative"
WIN_RES_P9_8  39  "p9000res.ini 640x480 vp  negative"
WIN_RES_P9_8  40  "p9000res.ini 640x480 vp  negative"
WIN_RES_P9_8  41  "system.ini boot fonts.fon vgasys.fon"

*
* Define modifications required for 800x600x32 60Hz.
* Note: Duplicate entries at the end of the list are required
*       in order to match the number of entries made during
*       Power 9100 installation!!!
*
WIN_RES_P9_9   1  "system.ini boot display.drv  p9000_32.drv"
WIN_RES_P9_9   2  "system.ini boot sdisplay.drv sp9k_32.drv"
WIN_RES_P9_9   3  "system.ini SP9000.DRV Font Small"
WIN_RES_P9_9   4  "system.ini P9000.DRV Resolution 800x600"
WIN_RES_P9_9   5  "system.ini P9000.DRV Refresh 60Hz"
WIN_RES_P9_9   6  "system.ini P9000.DRV Font Small"
WIN_RES_P9_9   7  "system.ini P9000.DRV Cursors 32"
WIN_RES_P9_9   8  "system.ini P9000.DRV Palette Standard"
WIN_RES_P9_9   9  "system.ini P9000.DRV DevBits Off"
WIN_RES_P9_9  10  "system.ini P9000.OEM BusType DETECT"
WIN_RES_P9_9  11  "system.ini P9000.OEM DacType BT485"
WIN_RES_P9_9  12  "system.ini P9000.OEM MemSize 2"
WIN_RES_P9_9  13  "system.ini P9000.OEM CursorUpdate On"
WIN_RES_P9_9  14  "system.ini P9000.OEM Cursor Power"
WIN_RES_P9_9  15  "system.ini P9000.OEM Speed 33.00mHz"
WIN_RES_P9_9  16  "system.ini P9000.OEM Monitor Generic"
WIN_RES_P9_9  17  "system.ini P9000.OEM DefMode 1024x768x8"
WIN_RES_P9_9  18  "p9000res.ini 800x600x32 link 800x600"
WIN_RES_P9_9  19  "p9000res.ini 800x600 hdr 40mHz"
WIN_RES_P9_9  20  "p9000res.ini 800x600 hsp 128"
WIN_RES_P9_9  21  "p9000res.ini 800x600 hbp 88"
WIN_RES_P9_9  22  "p9000res.ini 800x600 had 800"  
WIN_RES_P9_9  23  "p9000res.ini 800x600 hfp 40"
WIN_RES_P9_9  24  "p9000res.ini 800x600 hco 192"  
WIN_RES_P9_9  25  "p9000res.ini 800x600 hp  positive"
WIN_RES_P9_9  26  "p9000res.ini 800x600 vlr 60Hz"
WIN_RES_P9_9  27  "p9000res.ini 800x600 vsp 4"
WIN_RES_P9_9  28  "p9000res.ini 800x600 vbp 23"
WIN_RES_P9_9  29  "p9000res.ini 800x600 vad 600" 
WIN_RES_P9_9  30  "p9000res.ini 800x600 vfp 1"
WIN_RES_P9_9  31  "p9000res.ini 800x600 vco 22"  
WIN_RES_P9_9  32  "p9000res.ini 800x600 vp  positive"
WIN_RES_P9_9  33  "p9000res.ini 800x600 vp  positive"
WIN_RES_P9_9  34  "p9000res.ini 800x600 vp  positive"
WIN_RES_P9_9  35  "p9000res.ini 800x600 vp  positive"
WIN_RES_P9_9  36  "p9000res.ini 800x600 vp  positive"
WIN_RES_P9_9  37  "p9000res.ini 800x600 vp  positive"
WIN_RES_P9_9  38  "p9000res.ini 800x600 vp  positive"
WIN_RES_P9_9  39  "p9000res.ini 800x600 vp  positive"
WIN_RES_P9_9  40  "p9000res.ini 800x600 vp  positive"
WIN_RES_P9_9  41  "system.ini boot fonts.fon vgasys.fon"

* echo command to logfile in case cmd doesn't exist (error msg said bad path)
:RUN :MODE=PRIMARY :MODE=WINDOWS
CMD.EXE /C ECHO %BOOTDRIVE%:\OS2\INSTALL\TST4WOW.CMD %BOOTDRIVE%: %BOOTDRIVE%:\OS2\INSTALL\P90FU.DSA %BOOTDRIVE%:\OS2\INSTALL\P90WO.DSA 2>> %BOOTDRIVE%:\OS2\INSTALL\DSPINSTL.LOG 1>&2
CMD.EXE /C      %BOOTDRIVE%:\OS2\INSTALL\TST4WOW.CMD %BOOTDRIVE%: %BOOTDRIVE%:\OS2\INSTALL\P90FU.DSA %BOOTDRIVE%:\OS2\INSTALL\P90WO.DSA 2>> %BOOTDRIVE%:\OS2\INSTALL\DSPINSTL.LOG

*End of file*
