/** ColEm: portable Coleco emulator **************************/
/**                                                         **/
/**                          ColEm.c                        **/
/**                                                         **/
/** This file contains generic main() procedure statrting   **/
/** the emulation.                                          **/
/**                                                         **/
/** Copyright (C) Marat Fayzullin 1994-1998                 **/
/**     You are not allowed to distribute this software     **/
/**     commercially. Please, notify me, if you make any    **/
/**     changes to this file.                               **/
/*************************************************************/

#include "Coleco.h"
#include "Help.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>

// start OS/2 specific
#include "sndos2.h"
#include "os2.h"
#define INCL_WINSTDFILE   // OS/2 include for File Dialog
#define INCL_WINDIALOGS   // OS/2 include for Window Dialog
#include <os2.h>
char* ColecoRom;
char* ColemHelp;
char* ColemIni;
int newgame = FALSE;
int firstgame = 0;
// end OS/2 specific


char *Options[]=
{
  "verbose","hperiod","vperiod","uperiod","help",
  "autoa","noautoa","autob","noautob","logsnd",
  "trap","sound","nosound","shm","noshm","saver",
  "nosaver","vsync","novsync",0
};

extern char *Title;      /* Program title                       */
extern int   UseSound;   /* Sound mode (#ifdef SOUND)           */
extern int   UseSHM;     /* Use SHM X extension (#ifdef MITSHM) */
extern int   SaveCPU;    /* Pause when inactive (#ifdef UNIX)   */
extern int   SyncScreen; /* Sync screen updates (#ifdef MSDOS)  */


/** main() ***************************************************/
/** This is a main() function used in Unix and MSDOS ports. **/
/** It parses command line arguments, sets emulation        **/
/** parameters, and passes control to the emulation itself. **/
/*************************************************************/
int main(int argc,char *argv[])
{
  char CartName[CCHMAXPATH] = "";
  int N,J,I;


#ifdef DEBUG
  CPU.Trap=0xFFFF;CPU.Trace=0;
#endif

#ifdef MSDOS
  Verbose=0;
#else
  Verbose=5;
#endif

// start OS/2 specific
   ColecoRom = (char*) malloc(CCHMAXPATH);
   memset(ColecoRom, 0, CCHMAXPATH);
   char* separator = strrchr(argv[0], PATH_SEPARATOR);
   if(separator != 0)
   {
      strncpy(ColecoRom, argv[0], separator - argv[0]);
      strcat(ColecoRom, "\\coleco.rom");
   }
   else
      strcpy(ColecoRom, "coleco.rom");

  ColemHelp = (char*) malloc(CCHMAXPATH);
  memset(ColemHelp, 0, CCHMAXPATH);
  separator = strrchr(argv[0], PATH_SEPARATOR);
  if(separator != 0)
  {
     strncpy(ColemHelp, argv[0], separator - argv[0]);
     strcat(ColemHelp, "\\colem.inf");
  }
  else
     strcpy(ColemHelp, "colem.inf");

   ColemIni = (char*) malloc(CCHMAXPATH);
   memset(ColemIni, 0, CCHMAXPATH);
   separator = strrchr(argv[0], PATH_SEPARATOR);
   if(separator != 0)
   {
      strncpy(ColemIni, argv[0], separator - argv[0]);
      strcat(ColemIni, "\\colem.ini");
   }
   else
      strcpy(ColemIni, "colem.ini");
// end OS/2 specific

  for(N=1,I=0;N<argc;N++)
    if(*argv[N]!='-')
      switch(I++)
      {
        case 0: /* CartName=argv[N]; */ break;
        default: printf("%s: Excessive filename '%s'\n",argv[0],argv[N]);
      }
    else
    {
      for(J=0;Options[J];J++)
        if(!strcmp(argv[N]+1,Options[J])) break;
      switch(J)
      {
        case 0:  N++;
                 if(N<argc) Verbose=atoi(argv[N]);
                 else printf("%s: No verbose level supplied\n",argv[0]);
                 break;
        case 1:  N++;
                 if(N>=argc)
                   printf("%s: No HBlank period supplied\n",argv[0]);
                 else
                 {
                   J=atoi(argv[N]);
                   if((J>=30)&&(J<=3000)) HPeriod=J;
                 }
                 break;
        case 2:  N++;
                 if(N>=argc)
                   printf("%s: No VBlank period supplied\n",argv[0]);
                 else
                 {
                   J=atoi(argv[N]);
                   if((J>=1000)&&(J<=100000)) VPeriod=J;
                   if((J>=256)&&(J<=999)) VPeriod=HPeriod*J;
                 }
                 break;
  	case 3:  N++;
                 if(N>=argc)
                   printf("%s: No screen update period supplied\n",argv[0]);
                 else
                 {
                   J=atoi(argv[N]);
                   if((J>=1)&&(J<=20)) UPeriod=J;
                 }
                 break;
	case 4:  printf
                 ("%s by Marat Fayzullin    (C)FMS 1994-1998\n",Title);
                 for(J=0;HelpText[J];J++) puts(HelpText[J]);
                 return(0);
        case 5:  AutoA=1;break;
        case 6:  AutoA=0;break;
        case 7:  AutoB=1;break;
        case 8:  AutoB=0;break;
        case 9:  N++;
                 if(N<argc) SndName=argv[N];
                 else printf("%s: No file for soundtrack logging\n",argv[0]);
                 break;
#ifdef DEBUG
        case 10: N++;
                 if(N>=argc)
                   printf("%s: No trap address supplied\n",argv[0]);
                 else
                   if(!strcmp(argv[N],"now")) CPU.Trace=1;
                   else sscanf(argv[N],"%hX",&CPU.Trap);
                 break;
#endif
#ifdef SOUND
        case 11: N++;
                 if(N>=argc) { UseSound=1;N--; }
                 else if(sscanf(argv[N],"%d",&UseSound)!=1)
                      { UseSound=1;N--; }
                 break;
        case 12: UseSound=0;break;
#endif
#ifdef UNIX
#ifdef MITSHM
        case 13: UseSHM=1;break;
        case 14: UseSHM=0;break;
#endif
        case 15: SaveCPU=1;break;
        case 16: SaveCPU=0;break;
#endif
#ifdef MSDOS
        case 17: SyncScreen=1;break;
        case 18: SyncScreen=0;break;
#endif
        default: printf("%s: Wrong option '%s'\n",argv[0],argv[N]);
      }
    }

  for (I = 0;I<argc;I++)
     firstgame = I;

  if (firstgame != 0)
     strcpy(CartName, argv[firstgame]);


  DosSetCurrentDir("ROMS");   /* default into ROMS directory if present */

  if(!InitMachine()) return(1);
  for(;;)
  {
     if (GetCartridge(CartName) == FALSE) /* display file dialog to get cartridge */
        break;
     newgame = FALSE;
     StartColeco(CartName);
     audio_quiet();
     TrashColeco();
     if (newgame == FALSE) break;
  }
  TrashMachine();
  return(0);

}
