// ----------------------------------------------------------------------------
//	M88 - PC-8801 series emulator
//	Copyright (C) cisc 1999.
// ----------------------------------------------------------------------------
//	CD-ROM C^[tF[X̎
// ----------------------------------------------------------------------------
//	$Id: cdif.h,v 1.1 1999/06/20 05:27:30 cisc Exp $

#ifndef pc88_cdif_h
#define pc88_cdif_h

#include "device.h"

namespace PC8801
{
class PD8257;

class CDIF : public Device
{
public:
	enum IDIn
	{
		in90=0, in91, in92, in93, in96, in98, in99, in9b, in9d,
	};
	enum IDOut
	{
		out90=0, out91, out94, out97, out98, out99, out9f,
	};

public:
	CDIF(const ID& id);
	~CDIF();
	const Descriptor* GetDesc() const { return &descriptor; }
	bool Init(PD8257* dmac);

	void Reset();
	void Out90(uint, uint d);
	void Out91(uint, uint d);
	void Out94(uint, uint d);
	void Out97(uint, uint d);
	void Out98(uint, uint d);
	void Out99(uint, uint d);
	void Out9f(uint, uint d);
	uint In90(uint);
	uint In91(uint);
	uint In92(uint);
	uint In93(uint);
	uint In96(uint);
	uint In98(uint);
	uint In99(uint);
	uint In9b(uint);
	uint In9d(uint);

private:
	void IO();
	void ProcessCommand();
	
	PD8257* dmac;
	int cmdphase;			// R}hp[^ԍ
	int cmdlen;
	
	uint status;			// in 90
	uint data;				// port 91
	uint playmode;			// port 98

	uint8 clk;
	bool enable;

	uint8 cmdbuf[16];

	static const Descriptor descriptor;
	static const InFuncPtr indef[];
	static const OutFuncPtr outdef[];
};

}; // namespace PC8801

#endif // pc88_cdif_h
