// ---------------------------------------------------------------------------
//	M88 - PC-8801 Emulator
//	Copyright (C) cisc 1997, 1999.
// ---------------------------------------------------------------------------
//	$Id: opnif.h,v 1.5 1999/07/11 05:27:43 cisc Exp $

#ifndef PC88_OPNIF_H
#define PC88_OPNIF_H

#include "device.h"
#include "opna.h"
#include "psg.h"

// ---------------------------------------------------------------------------

class PC88;
class Scheduler;

//#define USE_OPN

namespace PC8801
{
class Sound;

// ---------------------------------------------------------------------------
//	88 p OPN Unit
//
class OPNIF : public Device
{
public:
	enum IDFunc
	{
		reset=0, setindex0, setindex1, writedata0, writedata1, setintrmask,
		readstatus=0, readstatusex, readdata0, readdata1,
	};

public:
	OPNIF(const ID& id, int imaskbit);
	~OPNIF();
	
	bool Init(Bus* bus, int intrport, int io, Scheduler* s, uint c, uint r);
	void SetSound(Sound* s) { sound = s; }
	
	bool SetRate(uint c, uint r);
	void Mix(FM::Sample* buffer, int nsamples);
	void SetVolume(const Config* config);
	
	void Enable(bool en) { enable = en; }
	void SetOPNMode(bool _opna) { opnamode = _opna; }
	const uint8* GetRegs() { return regs; }
	
	void SetIntrMask(uint, uint intrmask);
	void Reset		(uint=0, uint=0);
	void SetIndex0	(uint, uint data);
	void SetIndex1	(uint, uint data);
	void WriteData0	(uint, uint data);
	void WriteData1	(uint, uint data);
	uint ReadData0	(uint);
	uint ReadData1	(uint);
	uint ReadStatus	(uint);
	uint ReadStatusEx(uint);
	
	void TimeEvent(uint=0);
	
	const Descriptor* GetDesc() const { return &descriptor; }

private:
	void UpdateTimer();

private:
	class OPNUnit : 
#ifndef USE_OPN
	public FM::OPNA
#else
	public FM::OPN
#endif
	{
	public:
		OPNUnit() : bus(0) {}
		~OPNUnit() {}
		void Intr(bool f);
		void SetIntr(Bus* b, int p) { bus = b, pintr = p; }
		void SetIntrMask(bool e);

	private:
		Bus* bus;
		int pintr;
		bool intrenabled;
		bool intrpending;
	};

	OPNUnit opn;
	PSG psg;
	Bus* bus;
	Scheduler* scheduler;
	Sound* sound;
	int32 clock;
	int32 nextcount;
	int imaskbit;
	int srate;
	int prevtime;
	int portio;

	uint8 presc;
	bool opnamode;
	bool enable;
	
	uint index0;
	uint index1;
	uint data1;
	
	uint8 regs[0x200];

	static int prescaler;

	static const Descriptor descriptor;
	static const InFuncPtr  indef[];
	static const OutFuncPtr outdef[];
};

}

#endif // PC88_OPNIF_H
