// ---------------------------------------------------------------------------
//	M88 - PC-8801 Emulator
//	Copyright (C) cisc 1997, 1999.
// ---------------------------------------------------------------------------
//	$Id: sound.h,v 1.15 1999/07/11 05:27:43 cisc Exp $

#ifndef PC88_SOUND_H
#define PC88_SOUND_H

#include "device.h"
#include "opna.h"
#include "psg.h"
#include "soundbuf.h"

// ---------------------------------------------------------------------------

#define SOUND_55K	55555	// Special

class PC88;
class Scheduler;

namespace PC8801
{
class Sound;
class Config;
class OPNIF;

// ---------------------------------------------------------------------------
//
//
class Sound : public Device, public SoundBuffer
{
public:
	enum IDFunc
	{
		out40=0, updatecounter,
	};

public:
	Sound(const ID& id);
	~Sound();
	
	bool Init(PC88* pc, uint rate, uint32 clock, int bufsize);
	void Cleanup();	
	const Descriptor* GetDesc() const { return &descriptor; }
	
	void ApplyConfig(const Config* config);
	void SetVolume(const Config* config);
	bool SetRate(uint rate, uint32 clock, int bufsize);
	
	void UpdateCounter(uint=0, uint=0);
	void Out40(uint, uint data);

	void Update();
	
protected:
	void Mix(Sample* dest, int samples);
	
	uint samplingrate;		// TvO[g
	uint rate50;			// samplingrate / 50

private:
	void MixBeep(int32* dest, int samples);

	PC88* pc;
	int32* mixingbuf;
	
	uint32 prevtime;
	uint32 cfgflg;
	int tdiff;
	int mixthreshold;
	int buffersize;
	int bslice;
	int pslice;
	int bcount;
	int bperiod;

	uint port40;
	uint p40mask;
	bool enabled;
	bool opn2enabled;
	OPNIF* opn1;
	OPNIF* opn2;

	static const Descriptor descriptor;
	static const OutFuncPtr outdef[];
};

}

#endif // PC88_SOUND_H
