// ---------------------------------------------------------------------------
//  M88 - PC8801 emulator
//  Copyright (C) cisc 1998, 1999.
// ---------------------------------------------------------------------------
//  DirectDraw ɂSʕ`
// ---------------------------------------------------------------------------
//  $Id: DrawDDS.h,v 1.2 1999/04/06 06:12:35 cisc Exp $

#if !defined(win32_drawdds_h)
#define win32_drawdds_h

#include "WinDraw.h"

// ---------------------------------------------------------------------------

class WinDrawDDS : public WinDrawSub
{
public:
    WinDrawDDS(bool force480 = true);
    ~WinDrawDDS();

    bool Init(HWND hwnd);
    void Resize(uint w, uint h);
    bool Cleanup();

    void SetPalette(PALETTEENTRY* pal);
    void QueryNewPalette();
    void DrawScreen(int top, int bottom, bool refresh);
    bool Lock(uint8** pimage, int* pbpl);
    bool Unlock();
    void SetGUIMode(bool guimode);

private:
    bool guimode;
    void FillBlankArea();
    bool RestoreSurface();
    bool SetScreenMode();
    bool CreateDDPalette();
    bool CreateDD2();
    bool CreateDDS();

#ifdef __OS2__
#else
    static HRESULT WINAPI EDMCallBack(LPDDSURFACEDESC, LPVOID);
#endif

    HWND hwnd;

#ifdef __OS2__
#else
    LPDIRECTDRAW2 ddraw;
    LPDIRECTDRAWPALETTE ddpal;
    LPDIRECTDRAWSURFACE ddsscrn;
    LPDIRECTDRAWCLIPPER ddcscrn;
    LPDIRECTDRAWSURFACE ddswork;
#endif

    uint8* image;
    int bpl;
    int lines;      // 400 or 480
    int screenheight;
    bool palchanged;

    PALETTEENTRY palentry[256];
};


#endif // !defined(win32_drawdds_h)
