// ---------------------------------------------------------------------------
//	M88 - PC-8801 Emulator.
//	Copyright (C) cisc 1998, 1999.
// ---------------------------------------------------------------------------
//  J_v(PD1990) ̃G~[V for Win32
// ---------------------------------------------------------------------------
//	$Id: calender.h,v 1.1 1999/03/18 12:20:06 cisc Exp $

#if !defined(win32_pc88_calender_h)
#define win32_pc88_calender_h

#include "device.h"

namespace PC8801
{

class Calender : public Device  
{
public:
	enum
	{
		reset = 0, out10, out40,
		in40 = 0,
	};
public:
	Calender(const ID& id); 
	~Calender();

	const Descriptor* GetDesc() const { return &descriptor; }

	void Out10(uint, uint data);
	void Out40(uint, uint data);
	uint In40(uint);
	void Reset(uint=0, uint=0);

private:
	void ShiftData();
	uint8 BCD(uint8 n);
	void Command();

	void SetTime();
	void GetTime();

	FILETIME diff;

	bool dataoutmode;
	bool hold;
	uint8 datain;
	uint8 strobe;
	uint8 cmd, scmd, pcmd;
	uint8 reg[6];
	
	static const Descriptor descriptor;
	static const InFuncPtr  indef[];
	static const OutFuncPtr outdef[];
};

}

#endif // !defined(win32_pc88_calender_h)
