// ---------------------------------------------------------------------------
//  M88 - PC-8801 Emulator.
//  Copyright (C) cisc 1998, 1999.
// ---------------------------------------------------------------------------
//  $Id: wincore.cpp,v 1.16 1999/07/22 15:57:29 cisc Exp $

#include "headers.h"
#include <process.h>
#include "wincore.h"
#include "WinKeyIF.h"
#include "misc.h"
#include "pc88/config.h"
#include "status.h"

//#define LOGNAME "wincore"
#include "diag.h"

using namespace PC8801;

// ---------------------------------------------------------------------------
//  \z/
//
WinCore::WinCore()
: sound('SND '), caln('CALN'), mouse('MOUS')
{
    hthread = 0;
    execcount = 0;
}

WinCore::~WinCore()
{
}

// ---------------------------------------------------------------------------
//  
//
bool WinCore::Init(WinUI* _ui, HWND hwnd, Draw* draw, WinKeyIF* keyb)
{
    ui = _ui;

    if (!pc88.Init(draw))
        return false;

    if (!sound.Init(&pc88, hwnd, 0, 3993600, 0))
        return false;

    if (!ConnectDevices(keyb))
        return false;

    execute = false;
    shouldterminate = false;
    padenable = false;
    mouseenable = false;
    execcount = 0;
    guicount = 0;
    clock = 40;
#ifdef __OS2__
    if (!hthread)
    {
        hthread = _beginthread( ThreadEntry, NULL, 4096*1024, (void *)this );
        if (hthread == -1)
            return false;
    }
#else
    if (!hthread)
    {
        hthread = HANDLE(_beginthreadex(NULL, 0, ThreadEntry,
                            reinterpret_cast<LPVOID>(this), 0, &idthread));
        if (!hthread)
            return false;
    }
#endif
    return true;
}

// ---------------------------------------------------------------------------
//  n
//
bool WinCore::Cleanup()
{
#ifdef __OS2__
    if (hthread)
    {
//        shouldterminate = true;
//        if (WAIT_TIMEOUT == WaitForSingleObject(hthread, 3000))
//            TerminateThread(hthread, 0);
//        CloseHandle(hthread);
        hthread = 0;
    }
#else
    if (hthread)
    {
        shouldterminate = true;
        if (WAIT_TIMEOUT == WaitForSingleObject(hthread, 3000))
            TerminateThread(hthread, 0);
        CloseHandle(hthread);
        hthread = 0;
    }
#endif
    return true;
}

// ---------------------------------------------------------------------------
//  Zbg
//
void WinCore::Reset()
{
    CriticalSection::Lock lock(cs_cpu);
    pc88.Reset();
}

// ---------------------------------------------------------------------------
//  Core Thread
//
#ifdef __OS2__
uint WinCore::ThreadMain()
{
    LONG time = GetTime();

    int effclock = 100;

    while (!shouldterminate)
    {
        if (execute)
        {
            if (!clock)
            {
                time = GetTime();
                LONG ms = 0;
                int eclk = 0;
                do
                {
                    Execute(effclock, 500);
                    eclk+=5;
                    ms = GetTime() - time;
                } while (ms < 10);

                // ̎NbNvZ  A 10GHz? (^^;
                effclock = Min((Min(1000, eclk) * effclock / ms) + 1, 10000);
            }
            else
            {
                if (clock > 0)
                {
                    int dt = GetTime() - time;
                    int ms = Limit(dt, 50, 4);
                    time += dt;                             // time  I\莞
                    Execute(clock, ms * 100);

                    int idletime = time - GetTime() + 10;   // idletime  ]莞
//                  LOG3("Time: %d  Ex: %d ms  It: %d ms\n", GetTime(), ms, Max(0, idletime));
                    if (idletime > 0)
                        DosSleep(idletime);
                }
                else
                    Execute(-clock, 500);
            }
        }
        else
        {
            DosSleep(5);
            time = GetTime();
        }
    }
    return 0;
}
#else
uint WinCore::ThreadMain()
{
    DWORD time = GetTime();

    int effclock = 100;

    while (!shouldterminate)
    {
        if (execute)
        {
            if (!clock)
            {
                time = GetTime();
                DWORD ms = 0;
                int eclk = 0;
                do
                {
                    Execute(effclock, 500);
                    eclk+=5;
                    ms = GetTime() - time;
                } while (ms < 10);

                // ̎NbNvZ  A 10GHz? (^^;
                effclock = Min((Min(1000, eclk) * effclock / ms) + 1, 10000);
            }
            else
            {
                if (clock > 0)
                {
                    int dt = GetTime() - time;
                    int ms = Limit(dt, 50, 4);
                    time += dt;                             // time  I\莞
                    Execute(clock, ms * 100);

                    int idletime = time - GetTime() + 10;   // idletime  ]莞
//                  LOG3("Time: %d  Ex: %d ms  It: %d ms\n", GetTime(), ms, Max(0, idletime));
                    if (idletime > 0)
                        Sleep(idletime);
                }
                else
                    Execute(-clock, 500);
            }
        }
        else
        {
            Sleep(5);
            time = GetTime();
        }
    }
    return 0;
}
#endif

// ---------------------------------------------------------------------------
//  TuXbhJn_
//
#ifdef __OS2__
void WinCore::ThreadEntry(void *arg)
{
    HAB hab = WinInitialize( 0L );
    HMQ hmq = WinCreateMsgQueue( hab, 4096*1024 );
    ((WinCore *)arg)->ThreadMain();
}
#else
uint __stdcall WinCore::ThreadEntry(void* arg)
{
    return reinterpret_cast<WinCore*>(arg)->ThreadMain();
}
#endif

// ---------------------------------------------------------------------------
//  botC[v
//  clock   bot̃NbN(0.1MHz)
//  time    s鎞 (0.01ms)
//
void WinCore::Execute(long clk, long time)
{
    CriticalSection::Lock lock(cs_cpu);
    execcount += clk * pc88.Proceed(time, clk);
}

// ---------------------------------------------------------------------------
//  sNbNJEg̒lԂAJE^Zbg
//
long WinCore::GetExecCount()
{
    long i = execcount;
    execcount = 0;
    return i;
}

// ---------------------------------------------------------------------------
//  s~邩H
//
void WinCore::Wait(bool dowait)
{
    CriticalSection::Lock lock(cs_cpu);
    execute = !dowait;
}

// ---------------------------------------------------------------------------
//  Ԃ擾
//
#ifdef __OS2__
inline uint32 WinCore::GetTime()
{
    DATETIME pdt;
    ULONG a;

    DosGetDateTime( &pdt );
    a =   pdt.day     * (24 * 60 * 60 * 100)
        + pdt.hours   * (     60 * 60 * 100)
        + pdt.minutes * (          60 * 100)
        + pdt.seconds * (               100)
        + pdt.hundredths;
    return (uint32)a * 10;
}
#else
inline uint32 WinCore::GetTime()
{
    return timeGetTime();
}
#endif
// ---------------------------------------------------------------------------
//  ݒ𔽉f
//
void WinCore::ApplyConfig(PC8801::Config* cfg)
{
    clock = cfg->clock;
    if (cfg->flags & PC8801::Config::fullspeed)
        clock = 0;
    if (cfg->flags & PC8801::Config::cpuburst)
        clock = -clock;
    pc88.ApplyConfig(cfg);
    sound.ApplyConfig(cfg);
    pad.ApplyConfig(cfg);
    mouse.ApplyConfig(cfg);

    EnablePad((cfg->flags & PC8801::Config::enablepad) != 0);
    if (padenable)
        cfg->flags &= ~PC8801::Config::enablemouse;
    EnableMouse((cfg->flags & PC8801::Config::enablemouse) != 0);
}

// ---------------------------------------------------------------------------
//  GUI gptOݒ
//
void WinCore::SetGUIFlag(bool usegui)
{
    if (usegui)
    {
        if (!guicount++)
            mouse.Enable(false);
    }
    else
    {
        if (!--guicount)
            mouse.Enable(mouseenable);
    }
}

// ---------------------------------------------------------------------------
//  Windows p̃foCXڑ
//
bool WinCore::ConnectDevices(WinKeyIF* keyb)
{
    const static Bus::Connector c_keyb[] =
    {
        { PC88::pres, Bus::portout, WinKeyIF::reset },
        { PC88::vrtc, Bus::portout, WinKeyIF::vsync },
        { 0x00, Bus::portin, WinKeyIF::in },
        { 0x01, Bus::portin, WinKeyIF::in },
        { 0x02, Bus::portin, WinKeyIF::in },
        { 0x03, Bus::portin, WinKeyIF::in },
        { 0x04, Bus::portin, WinKeyIF::in },
        { 0x05, Bus::portin, WinKeyIF::in },
        { 0x06, Bus::portin, WinKeyIF::in },
        { 0x07, Bus::portin, WinKeyIF::in },
        { 0x08, Bus::portin, WinKeyIF::in },
        { 0x09, Bus::portin, WinKeyIF::in },
        { 0x0a, Bus::portin, WinKeyIF::in },
        { 0x0b, Bus::portin, WinKeyIF::in },
        { 0x0c, Bus::portin, WinKeyIF::in },
        { 0x0d, Bus::portin, WinKeyIF::in },
        { 0x0e, Bus::portin, WinKeyIF::in },
        { 0x0f, Bus::portin, WinKeyIF::in },
        { 0, 0, 0 }
    };
    if (!pc88.GetBus()->Connect(keyb, c_keyb)) return false;

    const static Bus::Connector c_caln[] =
    {
        { PC88::pres, Bus::portout, Calender::reset },
        { 0x10, Bus::portout, Calender::out10 },
        { 0x40, Bus::portout, Calender::out40 },
        { 0x40, Bus::portin,  Calender::in40 },
        { 0, 0, 0 }
    };
    if (!pc88.GetBus()->Connect(&caln, c_caln)) return false;

    const static Bus::Connector c_snd[] =
    {
        { 0x40,        Bus::portout, WinSound::out40 },
        { PC88::pint1, Bus::portout, WinSound::updatecounter },
        { 0, 0, 0 }
    };
    if (!pc88.GetBus()->Connect(&sound, c_snd)) return false;

    if (!mouse.Init(ui, &pc88)) return false;
    return true;
}

// ---------------------------------------------------------------------------
//  PAD ڑ
//
bool WinCore::EnablePad(bool enable)
{
    if (padenable == enable)
        return true;
    padenable = enable;

    CriticalSection::Lock lock(cs_cpu);
    if (enable)
    {
        const static Bus::Connector c_pad[] =
        {
            { PC88::popnio  , Bus::portin, WinJoyPad::getdir },
            { PC88::popnio+1, Bus::portin, WinJoyPad::getbutton },
            { PC88::vrtc,     Bus::portout, WinJoyPad::vsync },
            { 0, 0, 0 }
        };
        if (!pc88.GetBus()->Connect(&pad, c_pad)) return false;
        pad.Init();
    }
    else
    {
        pc88.GetBus()->Disconnect(&pad);
    }
    return true;
}

// ---------------------------------------------------------------------------
//  }EXڑ
//
bool WinCore::EnableMouse(bool enable)
{
    if (mouseenable == enable)
        return true;
    mouseenable = enable;

    CriticalSection::Lock lock(cs_cpu);
    if (enable)
    {
        const static Bus::Connector c_mouse[] =
        {
            { PC88::popnio  , Bus::portin, WinMouse::getmove },
            { PC88::popnio+1, Bus::portin, WinMouse::getbutton },
            { 0x40,           Bus::portout, WinMouse::strobe },
            { PC88::vrtc,     Bus::portout, WinMouse::vsync },
            { 0, 0, 0 }
        };
        if (!pc88.GetBus()->Connect(&mouse, c_mouse)) return false;
        ActivateMouse(true);
    }
    else
    {
        pc88.GetBus()->Disconnect(&mouse);
        ActivateMouse(false);
    }
    return true;
}

