/*
    File:       DragView.h
 
    Contains:	Main header file
 
    Written by: Michelle Wyner
 
    Created:    June 1997

    Copyright:  (c)1997 by Apple Computer, Inc., all rights reserved.

    Change History (most recent first):
                 June 1997 -- File first created.

    You may incorporate this sample code into your applications without
    restriction, though the sample code has been provided "AS IS" and the
    responsibility for its operation is 100% yours.  However, what you are
    not permitted to do is to redistribute the source as "DSC Sample Code"
    after having made changes. If you're going to re-distribute the source,
    we require that you make it clear in the source that the code was
    descended from Apple Sample Code, but that you've made changes.
*/

#import <AppKit/AppKit.h>

@interface DragView : NSView
{

    id fileField;

    //Outlets for the menu items in the View menu
    id cascadingOut;
    id ufsOut;
    id urlOut;

    //Outlets for the 'open' and 'reveal' buttons
    id openButton;
    id revealButton;

    NSArray *filenames;	// an array of the files which were dragged.
    NSArray *dragTypes;
    NSString *desiredType;
    NSString *filename;	//the name of the first file which was dragged.
    NSImage *image;
    NSPoint imageOrigin;
    id itemOn; //which menu item is the one which is currently checked?
   

}
- (id)initWithFrame:(NSRect)theRect;
- (void)dealloc;
- (void)awakeFromNib;
- (BOOL)application:(NSApplication *)theApplication openFile:(NSString *)filename;
- (BOOL)applicationShouldTerminateAfterLastWindowClosed:(NSApplication *)theApplication;
- (void)drawRect:(NSRect)theRect;
- (void)mouseDown:(NSEvent *)theEvent;


// ACTIONS
- (void)openDoc:(id)sender;
- (void)revealDoc:(id)sender;

- (void)setDragTypes:(NSArray *)newDragTypes;
- (void)setImage:(NSImage *)newImage;


// DRAG METHODS
- (unsigned int)draggingEntered:(id <NSDraggingInfo>)sender;
- (BOOL)performDragOperation:(id <NSDraggingInfo>)sender;
- (void)draggingExited:(id <NSDraggingInfo>)sender;
- (unsigned int)draggingUpdated:(id <NSDraggingInfo>)sender;
- (void)concludeDragOperation:(id <NSDraggingInfo>)sender;
- (unsigned int)draggingSourceOperationMaskForLocal:(BOOL)flag;

- (NSString *)indentLine:(NSString *)theString indentLevel:(unsigned int)numTabs;
- (void)viewChoice:(id)sender;
- (void)whatToDo;
- (void)getPathInfo:(NSString *)aFile;

- (void)doUFSThing;
- (void)doCascadingThing;
- (void)doURLThing;

@end
