#ifndef __MiscTableConnector_h
#define __MiscTableConnector_h
//=============================================================================
//
//	Copyright (C) 1996-1997 by Paul S. McCarthy and Eric Sunshine.
//		Written by Paul S. McCarthy and Eric Sunshine.
//			    All Rights Reserved.
//
//	This notice may not be removed from this source code.
//
//	This object is included in the MiscKit by permission from the authors
//	and its use is governed by the MiscKit license, found in the file
//	"License.rtf" in the MiscKit distribution.  Please refer to that file
//	for a list of all applicable permissions and restrictions.
//	
//=============================================================================
//-----------------------------------------------------------------------------
// MiscTableConnector.h
//
//	A custom sublcass of the internal Interface Builder
//	NSIBControlConnector class that works for doubleTarget / doubleAction.
//
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: MiscTableConnector.h,v 1.4 97/06/18 10:21:46 sunshine Exp $
// $Log:	MiscTableConnector.h,v $
//  Revision 1.4  97/06/18  10:21:46  sunshine
//  v125.9: Worked around Objective-C++ compiler crash in OPENSTEP 4.2 for NT
//  when sending message to 'super' from within a category in a permanent
//  fashion.
//  
//  Revision 1.3  96/04/30  05:38:57  sunshine
//  Ported to OpenStep 4.0 for Mach PR2.
//-----------------------------------------------------------------------------
extern "Objective-C" {
#import <InterfaceBuilder/InterfaceBuilder.h>
}
#import	"NSIBConnector.h"

@interface MiscTableConnector : NSIBControlConnector
    {
    NSString* outletName;	// Name of the "target" outlet.
    NSString* actionName;	// Name of the "action" variable.
    }

- (id)initWithCoder:(NSCoder*)coder;
- (void)dealloc;
- (void)establishConnection;

// See implementation for explanation of the following methods.
- (id)superInitSource:(id)src destination:(id)dest label:(NSString*)label;
- (void)superEncodeWithCoder:(NSCoder*)coder;

@end

#endif // __MiscTableConnector_h
