#ifndef __MiscTableScrollInspector_h
#define __MiscTableScrollInspector_h
//=============================================================================
//
//  Copyright (C) 1995,1996,1997,1998 by Paul S. McCarthy and Eric Sunshine.
//		Written by Paul S. McCarthy and Eric Sunshine.
//			    All Rights Reserved.
//
//	This notice may not be removed from this source code.
//
//	This object is included in the MiscKit by permission from the authors
//	and its use is governed by the MiscKit license, found in the file
//	"License.rtf" in the MiscKit distribution.  Please refer to that file
//	for a list of all applicable permissions and restrictions.
//	
//=============================================================================
//-----------------------------------------------------------------------------
// MiscTableScrollInspector.h
//
//	Interface Builder inspector for MiscTableScroll.
//
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: MiscTableScrollInspector.h,v 1.8 98/03/30 00:06:13 sunshine Exp $
// $Log:	MiscTableScrollInspector.h,v $
//  Revision 1.8  98/03/30  00:06:13  sunshine
//  v138.1: Ditched unnecessary "align title" text field since under OPENSTEP,
//  buttons are correctly dimmed when disabled.  Consequently I don't have to
//  worry about figuring out correct enabled/disabled colors for the field.
//  
//  Revision 1.7  98/03/22  13:07:57  sunshine
//  v133.1: Eliminated constrain-max, constrain-min is now implicit based on
//  presence/absence of auto-size slots.  Eliminated data-sizing.
//  Added alignment control.
//  
//  Revision 1.6  97/06/18  09:47:35  sunshine
//  v125.9: "highlighted" --> "selected" in method and outlet names.
//  Unified variable name style.
//-----------------------------------------------------------------------------
extern "Objective-C" {
#import <InterfaceBuilder/InterfaceBuilder.h>
}
#import <MiscTableScroll/MiscTableTypes.h>

@class NSButton, NSColorWell, NSMatrix, NSScrollView, NSTextField;
class MiscTableBorder;

@interface MiscTableScrollInspector : IBInspector
    {
    NSButton*		autosizeSwitch;
    NSButton*		autoSortSwitch;
    NSPopUpButton*	borderPopUp;
    NSPopUpButton*	cellClassPopUp;
    NSButton*		deleteButton;
    NSButton*		downButton;
    NSButton*		draggableSwitch;
    NSButton*		enabledSwitch;
    NSButton*		lazySwitch;
    NSPopUpButton*	modePopUp;
    NSButton*		sizableSwitch;
    NSPopUpButton*	sortTypePopUp;
    NSPopUpButton*	sortDirectionPopUp;
    NSPopUpButton*	titleModePopUp;
    NSButton*		titlesSwitch;
    NSButton*		upButton;
    NSButton*		userSizeableSwitch;
    NSMatrix*		alignMatrix;
    NSMatrix*		slotScroll;
    NSTextField*	sizeField;
    NSTextField*	sizeMaxField;
    NSTextField*	sizeMinField;
    NSTextField*	titleField;
    NSTextField*	uniformSizeField;
    NSColorWell*	colorText;
    NSColorWell*	colorTextSelected;
    NSColorWell*	colorBack;
    NSColorWell*	colorBackSelected;
    int			slot;		// Currently selected slot, or -1.
    int			numSlots;	// Total number of columns.
    MiscBorderType	borderType;
    MiscTableBorder*	border;
    BOOL		dirty;
    }

- (id)init;
- (void)ok:(id)sender;
- (void)revert:(id)sender;

@end

#endif	// __MiscTableScrollInspector_h
