//-----------------------------------------------------------------------------
// SokoApp.M
//
//	Application delegate for SokoSave.
//
// Copyright (c), 1997, Paul McCarthy.  All rights reserved.
// Copyright (c), 1997, Eric Sunshine.  All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoApp.M,v 1.2 97/12/10 06:56:00 sunshine Exp $
// $Log:	SokoApp.M,v $
//  Revision 1.2  97/12/10  06:56:00  sunshine
//  v10.1: Ported to OPENSTEP 4.1 for Mach, OPENSTEP 4.2 for Mach & Windows,
//  and Rhapsody Developer Release (RDR) for Mach and Windows (Yellow Box).
//  Added auto-save default.  Opening of "default" maze is no longer deferred
//  on Windows, and +nextMaze: is required to open a maze since an application
//  under Windows must have at least one window on-screen.
//  Now enables/disables the "Save All" menu appropriately.
//  
//  Revision 1.1  97/11/13  02:56:40  zarnuk
//  v9
//-----------------------------------------------------------------------------
#import	"SokoDefs.h"
#import "SokoApp.h"
#import	"SokoBoard.h"
#import "SokoInfo.h"
#import	"SokoFiles.h"
#import "SokoPref.h"
#import	"SokoScore.h"
extern "Objective-C" {
#import <AppKit/NSApplication.h>
#import <AppKit/NSMenu.h>
#import <AppKit/NSWorkspace.h>
#import	<Foundation/NSDictionary.h>
#import <Foundation/NSNotification.h>
#import <Foundation/NSUserDefaults.h>
#import <Foundation/NSValue.h>
}

@implementation SokoApp

- (void)new:(id)sender			{ [SokoBoard new:sender];}
- (void)open:(id)sender			{ [SokoBoard open:sender]; }
- (void)saveAll:(id)sender		{ [SokoBoard saveAll:sender]; }
- (void)launchInfo:(id)sender		{ [SokoInfo launch]; }
- (void)launchPreferences:(id)sender	{ [SokoPref launch]; }
- (void)launchScores:(id)sender		{ [SokoScore launch]; }

//-----------------------------------------------------------------------------
// -applicationWillFinishLaunching:
//-----------------------------------------------------------------------------
- (void)applicationWillFinishLaunching:(NSNotification*)notification
    {
    [[NSUserDefaults standardUserDefaults] registerDefaults:
	[NSDictionary dictionaryWithObjectsAndKeys:
		DEF_SAVE_DIR, SAVE_DIR,
		DEF_MAZE_DIR, MAZE_DIR,
		DEF_SCORES, SCORES,
		DEF_AUTO_SAVE, AUTO_SAVE,
		@"Yes", NEW_PLAYER,
		@"1", LEVEL,
		0]];

    [[[NSWorkspace sharedWorkspace] notificationCenter]
	addObserver:self selector:@selector(workspaceWillPowerOff:)
	name:NSWorkspaceWillPowerOffNotification object:0];
    }


//-----------------------------------------------------------------------------
// activate:
//-----------------------------------------------------------------------------
- (void)activate:(BOOL)mazeRequired
    {
    BOOL ok = ([SokoBoard openMazes] > 0);
    if (!ok)
	ok = [SokoBoard nextMaze:mazeRequired];

    if (!ok && mazeRequired)
	[NSApp terminate:self];
    else
	{
	NSUserDefaults* const defs = [NSUserDefaults standardUserDefaults];
	if ([defs boolForKey:NEW_PLAYER])
	    {
	    [defs setBool:NO forKey:NEW_PLAYER];
	    [self launchInfo:self];	// Give first-time users some help.
	    }
	}
    }


//-----------------------------------------------------------------------------
// -applicationDidFinishLaunching:
//-----------------------------------------------------------------------------
#ifndef SOKO_DEFERRED_LAUNCH
- (void)applicationDidFinishLaunching:(NSNotification*)notification
    {
    [self activate:YES];
    }
#endif


//-----------------------------------------------------------------------------
// -applicationDidBecomeActive:
//-----------------------------------------------------------------------------
#ifdef SOKO_DEFERRED_LAUNCH
- (void)applicationDidBecomeActive:(NSNotification*)notification
    {
    static BOOL checked = NO;		// Only do this the first time the 
    if (!checked)			// app becomes the active app.
	{
	checked = YES;
	[self activate:NO];
	}
    }
#endif


//-----------------------------------------------------------------------------
// -applicationShouldTerminate:
//-----------------------------------------------------------------------------
- (BOOL)applicationShouldTerminate:(id)sender
    {
    [[[NSWorkspace sharedWorkspace] notificationCenter]
	removeObserver:self name:NSWorkspaceWillPowerOffNotification object:0];
    [[NSUserDefaults standardUserDefaults] synchronize];
    [SokoScore terminate];
    return YES;
    }


//-----------------------------------------------------------------------------
// -workspaceWillPowerOff
//-----------------------------------------------------------------------------
- (void)workspaceWillPowerOff:(NSNotification*)notification
    {
    [self applicationShouldTerminate:0];
    }


//-----------------------------------------------------------------------------
// -application:openFile:
//-----------------------------------------------------------------------------
- (BOOL)application:(id)sender openFile:(NSString*)filename
    {
    return [SokoBoard openFile:filename];
    }


//-----------------------------------------------------------------------------
// -validateMenuItem:
//-----------------------------------------------------------------------------
- (BOOL)validateMenuItem:(NSMenuItem*)item
    {
    if ([item action] == @selector(saveAll:))
	return ([SokoBoard openMazes] > 0);
    return YES;
    }

@end
