#ifndef __SokoSave_SokoBoard_h
#define __SokoSave_SokoBoard_h
//-----------------------------------------------------------------------------
// SokoBoard.h
//
//	Object representing a single puzzle instance.
//
// Copyright (c), 1997, Paul McCarthy.  All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoBoard.h,v 1.2 97/12/10 07:04:58 sunshine Exp $
// $Log:	SokoBoard.h,v $
//  Revision 1.2  97/12/10  07:04:58  sunshine
//  v10.1: Ported to OPENSTEP 4.1 for Mach, OPENSTEP 4.2 for Mach & Windows,
//  and Rhapsody Developer Release (RDR) for Mach and Windows (Yellow Box).
//  Fixed bug: +nextMaze: was neglecting to send -makeKeyWindow to maze.
//  Fixed bug: When opening a saved game with a deferred window, the NSSlider
//  did not get drawn.  Was incorrectly & unnecessarily sending it a -sizeToFit
//  message.  For some reason, on deferred windows, this has the side-effect of
//  setting the slider's frame size to (0,0).
//  Fixed bug: New & Open panels failed to restrict allowed types to .sokomaze
//  and .sokosave, respectively.  Problem was they were using the inherited
//  -setRequiredFileType: method which seems to be ineffectual in NSOpenPanel.
//  Now explicitly uses -runModalForDirectory:file:types:.
//  Fixed bug: Opening a saved game with no history resulted in a "corrupt
//  moves/pushes" error message.  Problem was that an earlier fscanf() format
//  string was eating the blank line which represented the empty history.
//  Fixed bug: Opening a saved game with no history resulted in malloc(0).
//  Fixed bug: Opening a saved game would report "corrupt recorded values"
//  error in this case: 1) solve and save game, 2) undo two or more moves,
//  3) make a move which is not in the history, meaning no auto-redo, 4) save
//  game, 5) close game, 6) re-open game.  The problem was that at step 3, the
//  history was truncated.  Yet the load method was asserting that the
//  "recorded" moves/pushes had to be less than the history-length; which,
//  after truncation, is an invalid assertion.
//  Respects new "auto-save when solved" preference flag.
//  
//  Revision 1.1  97/11/13  02:56:36  zarnuk
//  v9
//-----------------------------------------------------------------------------
extern "Objective-C" {
#import <Foundation/NSObject.h>
@class SokoMatrix, NSBox, NSButton, NSSlider, NSTextField, NSWindow;
}

#define	ROWMAX 20
#define	COLMAX 40

typedef char BoardArray[ROWMAX][COLMAX+1];

@interface SokoBoard : NSObject
    {
    NSButton* animateSwitch;
    SokoMatrix* cellMatrix;
    NSBox* controlBox;
    NSButton* moveDownBtn;
    NSButton* moveDownLeftBtn;
    NSButton* moveDownRightBtn;
    NSButton* moveLeftBtn;
    NSButton* moveRightBtn;
    NSButton* moveUpBtn;
    NSButton* moveUpLeftBtn;
    NSButton* moveUpRightBtn;
    NSTextField* numMovesFld;
    NSTextField* numPushesFld;
    NSSlider* playbackSlider;
    NSButton* redoBtn;
    NSTextField* solvedLabel;
    NSButton* undoBtn;
    NSWindow* window;
    NSString* saveFileName;
    NSString* mazeFileName;
    int NUMROWS;
    int NUMCOLS;
    int	playerRow;
    int	playerCol;
    BoardArray board;
    int	history_max;
    int	history_len;
    int	history_pos;
    char* history;
    int numMoves;
    int numPushes;
    int recordedMoves;
    int recordedPushes;
    BOOL animating;
    }

+ (BOOL)nextMaze:(BOOL)required;
+ (SokoBoard*)newMaze:(NSString*)maze;
+ (SokoBoard*)oldMaze:(NSString*)saveName;
+ (BOOL)openFile:(NSString*)filename;
+ (void)new:(id)sender;
+ (void)open:(id)sender;
+ (void)saveAll:(id)sender;
+ (unsigned int)openMazes;

- (void)inspectPlaybackSlider:(id)sender;
- (void)moveDownPressed:(id)sender;
- (void)moveLeftPressed:(id)sender;
- (void)moveRightPressed:(id)sender;
- (void)moveUpPressed:(id)sender;
- (void)redoPressed:(id)sender;
- (void)undoPressed:(id)sender;
- (void)undoMove;
- (void)redoMove;

- (void)save:(id)sender;
- (void)saveAs:(id)sender;
- (void)makeKeyWindow;
- (void)orderFront:(id)sender;
- (NSString*)saveFileName;

@end

#endif // __SokoSave_SokoBoard_h
