#ifndef __SokoSave_SokoDefs_h
#define __SokoSave_SokoDefs_h
//-----------------------------------------------------------------------------
// SokoDefs.h
//
//	Defined constants for some factory default values.
//
// Copyright (c), 1997, Paul McCarthy.  All rights reserved.
//
// Platform and O/S specific definitions:
//
// __PRETTY_FUNCTION__
//	Defined under OPENSTEP 4.1 since the Objective-C++ compiler neglects
//	to do so even though the NSCAssert() macro and its cousings rely on it.
//	Under OPENSTEP 4.2 and better, the compiler automatically defines this.
//
// SOKO_DEFERRED_LAUNCH
//	Under OPENSTEP and Rhapsody for Mach, automatic opening of a "default"
//	maze is deferred until the application become the active appliation.
//	This prevents it from cluttering up the screen before it is actually
//	needed (such as if it is auto-launched at login time).  However, under
//	MS-Windows, an application *must* have at least one window open since
//	the main menu is attached to the window, rather than stand-alone as
//	it is under Mach.  Hence, opening the default maze is not deferred in
//	this case.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoDefs.h,v 1.2 97/12/10 06:56:39 sunshine Exp $
// $Log:	SokoDefs.h,v $
//  Revision 1.2  97/12/10  06:56:39  sunshine
//  v10.1: Ported to OPENSTEP 4.1 for Mach, OPENSTEP 4.2 for Mach & Windows,
//  and Rhapsody Developer Release (RDR) for Mach and Windows (Yellow Box).
//  Added auto-save default.  Added platform-specific definitions.
//  
//  Revision 1.1  97/11/13  02:56:24  zarnuk
//  v9
//-----------------------------------------------------------------------------
#ifdef __cplusplus
extern "Objective-C" {
#endif
#import <Foundation/NSPathUtilities.h>
#ifdef __cplusplus
}
#endif

#define	APPNAME		@"SokoSave"
#define	APPDIR		@"$(SokoSave)"
						// NXUserDefaults names.
#define	SAVE_DIR	@"SaveDirectory"
#define	MAZE_DIR	@"MazeDirectory"
#define	SCORES		@"ScoresFile"
#define	NEW_PLAYER	@"NewPlayer"
#define	LEVEL		@"Level"
#define AUTO_SAVE	@"AutoSave"
						// Factory default values.
#define	DEF_SAVE_DIR	[[NSHomeDirectory() stringByAppendingPathComponent:\
			@"Library"] stringByAppendingPathComponent:@"SokoSave"]
#define	DEF_MAZE_DIR	[APPDIR stringByAppendingPathComponent:@"Maze"]
#define	DEF_SCORES	[DEF_SAVE_DIR stringByAppendingPathComponent:@"/SCORES"]
#define DEF_AUTO_SAVE	@"Yes"
#define	FACTORY_SCORES	[APPDIR stringByAppendingPathComponent:@"/SCORES"]

#if defined(NX_CURRENT_COMPILER_RELEASE) && NX_CURRENT_COMPILER_RELEASE <= 400
# define __PRETTY_FUNCTION__ "<unknown>"		/* NOTE 1 */
#endif

#if defined(__WIN32__)
# undef  SOKO_DEFERRED_LAUNCH
#else
# define SOKO_DEFERRED_LAUNCH
#endif

#endif // __SokoSave_SokoDefs_h
