//-----------------------------------------------------------------------------
// SokoEncode.cc
//
//	Routines for using run length encoding for SokoSave.
//
// Copyright (c), 1997, Paul McCarthy.  All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoEncode.cc,v 1.2 97/12/10 06:57:10 sunshine Exp $
// $Log:	SokoEncode.cc,v $
//  Revision 1.2  97/12/10  06:57:10  sunshine
//  v10.1: Was unnecessarily including <assert.h>.
//  
//  Revision 1.1  97/11/13  02:56:18  zarnuk
//  v9
//-----------------------------------------------------------------------------
#include "SokoEncode.h"
extern "C" {
#include <ctype.h>
}

//-----------------------------------------------------------------------------
// runLengthEncodeChar
//-----------------------------------------------------------------------------
void runLengthEncodeChar( FILE *fp, char ch, int run_length )
    {
    if (run_length > 1)
	fprintf( fp, "%d", run_length );
    fputc( ch, fp );
    }


//-----------------------------------------------------------------------------
// runLengthEncodeString
//-----------------------------------------------------------------------------
void runLengthEncodeString( FILE *fp, char const *str, int str_length )
    {
    int run_length = 0;
    char last_ch,ch;

    if (str != 0)
	{
	last_ch = *str;
	while ((ch = *str++) != '\0' && str_length-- > 0)
	    {
	    if (ch == last_ch)
		run_length++;
	    else
		{
		runLengthEncodeChar( fp, last_ch, run_length );
		run_length = 1;
		last_ch = ch;
		}
	    }
	if (run_length > 0)
	    runLengthEncodeChar( fp, last_ch, run_length );
	}
    fputc( '\n', fp );
    }


//-----------------------------------------------------------------------------
// runLengthDecodeChar
//-----------------------------------------------------------------------------
int runLengthDecodeChar( FILE *fp, char *ch, int *run_length )
    {
    int rc = 0;		// Assume failure until success.
    int len = 0;
    int c;
    
    if (!feof(fp) && !ferror(fp))
	{
	c = fgetc( fp );
	if (c != EOF && isdigit(c))
	    {
	    do	{
		len = (len * 10) + (c - '0');
		c = fgetc( fp );
		}
	    while (c != EOF && isdigit(c));
	    }
	else
	    {
	    len = 1;
	    }
	if (c != EOF)
	    {
	    *ch = c;
	    *run_length = len;
	    rc = 1;
	    }
	}
    
    return rc;
    }


//-----------------------------------------------------------------------------
// runLengthDecodeString
//-----------------------------------------------------------------------------
int runLengthDecodeString( FILE *fp, char *buff, int buff_len )
    {
    int pos = 0;	// Position to store next character in buff.
    int run_length;	// run-length.
    char ch;		// character.
    
    while (runLengthDecodeChar( fp, &ch, &run_length ) && ch != '\n')
	{
	if (pos + run_length <= buff_len)
	    {
	    while (run_length-- > 0)
		buff[ pos++ ] = ch;
	    }
	else
	    {
	    pos = -1;
	    break;
	    }
	}

    return (ch == '\n' && pos == buff_len) ? 1 : 0;
    }

