//-----------------------------------------------------------------------------
// SokoInfo.M
//
//	Info panel object for SokoSave.
//
// Copyright (c), 1997, Paul McCarthy.  All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoInfo.M,v 1.2 97/12/10 06:59:03 sunshine Exp $
// $Log:	SokoInfo.M,v $
//  Revision 1.2  97/12/10  06:59:03  sunshine
//  v10.1: Ported to OPENSTEP 4.1 for Mach, OPENSTEP 4.2 for Mach & Windows,
//  and Rhapsody Developer Release (RDR) for Mach and Windows (Yellow Box).
//  
//  Revision 1.1  97/11/13  02:58:01  zarnuk
//  v9
//-----------------------------------------------------------------------------
#import "SokoInfo.h"
extern "Objective-C" {
#import <AppKit/NSNibLoading.h>
#import <AppKit/NSTextField.h>
#import <AppKit/NSTextView.h>
#import <Foundation/NSString.h>
}

@implementation SokoInfo

//-----------------------------------------------------------------------------
// -performPrint:
//-----------------------------------------------------------------------------
- (void)performPrint:(id)sender
    {
    [text print:sender];
    }


//-----------------------------------------------------------------------------
// -setField:file:prefix:
//-----------------------------------------------------------------------------
- (void)setField:(NSTextField*)fld file:(NSString*)file prefix:(NSString*)pfx
    {
    NSString* s = @"?find?";
    NSString* path = [[NSBundle mainBundle] pathForResource:file ofType:@""];
    if (path != 0)
	{
	s = [NSString stringWithContentsOfFile:path];
	if (s == 0)
	    s = @"?read?";
	}
    [fld setStringValue:[pfx stringByAppendingString:s]];
    }


//-----------------------------------------------------------------------------
// init
//-----------------------------------------------------------------------------
- (id)init
    {
    [super init];
    [NSBundle loadNibNamed:@"SokoInfo" owner:self];
    [self setField:releaseField file:@"RELEASE_NUMBER" prefix:@"Release "];
    [self setField:buildField file:@"PACKAGE_NUMBER" prefix:@"Build "];
    return self;
    }


//-----------------------------------------------------------------------------
// makeKeyAndOrderFront:
//-----------------------------------------------------------------------------
- (void)makeKeyAndOrderFront:(id)sender
    {
    [window makeKeyAndOrderFront:sender];
    }


//-----------------------------------------------------------------------------
// +launch
//-----------------------------------------------------------------------------
+ (void)launch
    {
    static id instance = 0;
    if (instance == 0)
	instance = [[self alloc] init];
    [instance makeKeyAndOrderFront:self];
    }

@end
