#ifndef __SokoPref_h
#define __SokoPref_h
//-----------------------------------------------------------------------------
// SokoPref.h
//
//	User preferences module for SokoSave.
//
// Copyright (c), 1997, Paul McCarthy.  All rights reserved.
// Copyright (c), 1997, Eric Sunshine.  All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoPref.h,v 1.2 97/12/10 07:00:11 sunshine Exp $
// $Log:	SokoPref.h,v $
//  Revision 1.2  97/12/10  07:00:11  sunshine
//  v10.1: Ported to OPENSTEP 4.1 for Mach, OPENSTEP 4.2 for Mach & Windows,
//  and Rhapsody Developer Release (RDR) for Mach and Windows (Yellow Box).
//  Fields are now reverted to their saved values when Cancel is pressed.
//  Set button now dismisses the panel.  Now marks the window dirty as changes
//  are made and, if dirty, prompts user when window's close button is pressed.
//  Now saves screen position.
//  
//  Revision 1.1  97/11/13  02:57:05  zarnuk
//  v9
//-----------------------------------------------------------------------------
extern "Objective-C" {
#import <Foundation/NSObject.h>
@class NSButton, NSTextField, NSWindow;
}

@interface SokoPref : NSObject
    {
    NSTextField* mazeDirField;
    NSTextField* saveDirField;
    NSTextField* scoresFileField;
    NSTextField* levelField;
    NSButton* autoSaveSwitch;
    NSWindow* window;
    BOOL visible;
    }

+ (void)launch;
+ (int)getLevel;
+ (void)setLevel:(int)level;
+ (BOOL)doesAutoSave;

@end

#endif //  __SokoPref_h
