#!/bin/sh
# trim_scores.sh
#
# Trim the SokoSave SCORES file to the best scores.
#

/bin/cat >/tmp/trim_scores.awk << __EOF__
BEGIN	{ MAZE = 0+0 }
	{
	M = 0 + \$1;
	if (MAZE != M)
		{
		MAZE = M;
		print \$0;
		}
	}
__EOF__

/usr/bin/sort -un +0 -1  +1 -2  +2 -3  +3 -4 SCORES | \
	/bin/awk -f /tmp/trim_scores.awk > SCORES_BY_MOVE
/usr/bin/sort -un +0 -1  +2 -3  +1 -2  +3 -4 SCORES | \
	/bin/awk -f /tmp/trim_scores.awk > SCORES_BY_PUSH

/usr/bin/sort -un +0 -1  +1 -2  +2 -3  +3 -4 \
	SCORES_BY_MOVE SCORES_BY_PUSH > SCORES

/bin/rm SCORES_BY_MOVE SCORES_BY_PUSH /tmp/trim_scores.awk
