// Editor.h 
//
// created by Martin Wennerberg on Sun 12-Nov-1995
//
// An Editor handles displaying of an image and it's morph lines.
// One can have any number of Editors for displaying the morph lines.
// The morph lines are displayed at a certain delta. A delta of zero
// is the first frame of the morph and a delta of one is the last.
//
// when		who	modification

#import <AppKit/AppKit.h>

@interface Editor : NSView
{
    NSImage	*image;
    float	 delta;
    BOOL	 editingIsEnabled;
    id		 delegate;
}
- (id)initWithFrame:(NSRect)frameRect;

- (NSImage *) image;
- (void) setImage:(NSImage *)im;
  // Sets the image displayed as background.
  // Also calls [delegate setImage:atDelta:]

- (void) setDelta:(float)d;
- (float) delta;

- (void) setEditingIsEnabled:(BOOL)yn;
- (BOOL) editingIsEnabled;

// Overrides from NSView

- (void)resizeWithOldSuperviewSize:(NSSize)oldSize;
  // Scales the image.
- (void)mouseDown:(NSEvent *)event;
  // Manipulates morph lines.
- (void)drawRect:(NSRect)rect;
  // Draws the image and the morphlines.

@end

/* Drag and drop of images into the Editor */

@interface Editor(Drag)

- (unsigned int)draggingEntered:(id <NSDraggingInfo>)sender;
- (unsigned int)draggingUpdated:(id <NSDraggingInfo>)sender;
- (BOOL)performDragOperation:(id <NSDraggingInfo>)sender;
	// Calls [self setImage:]
@end