// Inspector.m 
//
// created by Martin Wennerberg on Mon 05-Jan-1998
//
// when		who	modification

#import "Inspector.h"

@implementation Inspector
+ (Inspector *) sharedInspector
{
    static Inspector *sharedObj = nil;
    if (sharedObj == nil)
        sharedObj = [[self alloc] init];
    return sharedObj;
}

- (NSView *) view
{
    return view;
}

- (void) setView:(NSView *)inspectorView
{
    [view autorelease];
    view = [inspectorView retain];
}

- (BOOL) isValidInspectorForTargets:(NSArray *)inspectedObjects
{
    return NO;
}

- (void) setTargets:(NSArray *)inspectedObjects
{
    [_targets autorelease];
    _targets = [inspectedObjects retain];
}

- (NSArray *) targets
{
    return _targets;
}

- (void) revert:sender
{}
@end
