#import <AppKit/AppKit.h>
#import "Inspector.h"

#define NOTIFICATION_OBJECTS_UPDATED   @"objectsUpdated"
#define NOTIFICATION_SELECTION_CHANGED @"selectionChanged"

@protocol InspectorTarget
- (NSArray *)currentSelection;
@end

@interface InspectorController : NSObject
{
    IBOutlet NSBox    *inspectorBox;
    IBOutlet NSView   *emptySelectionInspectorView;
    IBOutlet NSWindow *offWin;
    NSMutableArray 	  *inspectors;
}
+ (InspectorController *) sharedInspectorController;

- init;

- (NSWindow *) panel;
- (void) registerInspector:(Inspector *)inspector;

- (void) revert:(id)sender;
@end
