// MorphDocument.h
//
// created by Martin Wennerberg on Sun 12-Nov-1995
//
// when		who	modification

#import "Document.h"

#define MORPH_DOC_EXTENTION @"morph2"
#define XMOVIE_EXTENTION    @"xmovie"
#define DICT_PATHCOMPONENT @"info.plist"
#define DICT_IMAGE0_PATH_KEY @"firstImagePath"
#define DICT_IMAGE1_PATH_KEY @"lastImagePath"
#define DICT_MORPHLINES_KEY @"morphLines"
#define DICT_VERSION_KEY @"version"

#define FILEVERSION   1

@class MorphLine;
@class Editor;
@class NSProgressIndicator;
@class NSTextField;
@class NSBox;
@class NSView;
@class NSImage;
@class NSMatrix;

@interface MorphDocument : Document
{
    IBOutlet Editor	   	   *firstEditor;
    IBOutlet Editor		   *lastEditor;
    IBOutlet NSTextField   *frameCountField;
    IBOutlet NSTextField   *frameHeightField;
    IBOutlet NSTextField   *frameWidthField;
    IBOutlet NSBox         *frameSettingsView;
    IBOutlet NSBox		   *previewBox;
    IBOutlet NSProgressIndicator *progressIndicator;
    IBOutlet NSView		   *progressView;
    NSMatrix               *previewMatrix;
    NSImage	               *firstImage;
    NSImage	               *lastImage;
    NSMutableArray         *morphLines;
    NSMutableArray         *selectedLines;
}

// Methods from super class

+ (NSSet *) readableFileTypes;
- initWithContentsOfFile:(NSString *)file;

- (NSArray *) morphLines;
- (void) addMorphLine:(MorphLine *)morphLine;
- (void) deleteMorphLine:(MorphLine *)morphLine;

    // Access methods
- (NSImage *) imageAtDelta:(float)delta;
- (void) setImage:(NSImage *)image atDelta:(float)delta;

- (NSWindow *)window;

    // Actions
- (void) calcPreview:sender;

- (void) save:sender;
- (void) saveAs:sender;
- (void) saveTo:sender;
- (void) saveFrames:sender;

- (void) selectAll:sender;
- (void) selectNone:sender;
- (void) addToCurrentSelection:(id)obj;
- (void) removeFromCurrentSelection:(id)obj;
- (NSArray *) currentSelection;

- (void) calcFramesAndSaveToPath:(NSString *)dirPath count:(unsigned int)frameCount size:(NSSize)frameSize;
@end
