// MorphLine.h 
//
// created by Martin Wennerberg on Sun 12-Nov-1995
//
// when		who	modification

#import <AppKit/AppKit.h>

#define	MLKEY_STARTPOINTS	@"startPoints"
#define	MLKEY_ENDPOINTS		@"endPoints"
#define	MLKEY_MOVESTART		@"moveStartDelta"
#define	MLKEY_MOVEEND		@"moveEndDelta"
#define	MLKEY_DISSOLVESTART	@"dissolveStartDelta"
#define	MLKEY_DISSOLVEEND	@"dissolveEndDelta"

@class NSAffineTransform;

@interface MorphLine : NSObject
{
@public
    NSPoint	*startPoints;
    NSPoint	*endPoints;
    unsigned	nPoints;
    float	moveStartDelta;
    float	moveEndDelta;
    float	dissolveStartDelta;
    float	dissolveEndDelta;
}
- init;
- initWithValuesInDict:(NSDictionary *)dict;
- (NSDictionary *)pList;

    /* controls */
- (NSPoint) startPointAtDelta:(float)d;
- (NSPoint) endPointAtDelta:(float)d;
- (void) setStartPoint:(NSPoint)aPoint atDelta:(float)delta;
- (void) setEndPoint:(NSPoint)aPoint atDelta:(float)delta;
- (void) setMoveStartDelta:(float)a;
- (void) setMoveEndDelta:(float)a;
- (void) setDissolveStartDelta:(float)a;
- (void) setDissolveEndDelta:(float)a;
- (float) moveStartDelta;
- (float) moveEndDelta;
- (float) dissolveStartDelta;
- (float) dissolveEndDelta;
- (BOOL) hitTest:(NSPoint) aPoint;
- (int) hitKnobTest: (NSPoint) aPoint;

    /* Displaying */
- (void) drawInView:(NSView *)view delta:(float)delta;

    /* mathematics */
- (NSAffineTransform *) transformFromDelta:(float)beforeDelta toDelta:(float)afterDelta;

    /* description */
- (NSString *) description;

@end
