// NSBitmapImageRep_editing.m 
//
// Implements pixel color manipulations for bitmaps.
// Only works for a few image formags such as 24 bit RGB and 8 bit gray.
// This code should be rewritten or complemented to handle all possible data
// formats. Anti aliasing would me nice as well.
//
// created by Martin Wennerberg on Sun 11-Aug-1996
//
// when		who	modification

#import "NSBitmapImageRep_editing.h"

#ifndef rint
#define rint(x)	((x) + 0.5)
#endif

@implementation NSBitmapImageRep(editing)
- (void) setRGBA:(struct RGBA) col atPoint:(NSPoint) point
{
    int		i;
    int		numColors = _moreRepFlags.numColors;
    int		bytesPerRow = _bytesPerRow;
    BOOL	isPlanar = _moreRepFlags.isPlanar;
    unsigned char	*planes[5];
    unsigned char	*plane;
    int			 x, y;
    NSSize		 size;

    size = [self size];
    x = rint (point.x);
    y = rint (size.height - point.y) - 1;
    if (x < 0 || x > size.width || y < 0 || y > size.height)
        return;

    [self getBitmapDataPlanes:planes];

    if (!isPlanar)
    {
        plane = planes[0];
        i = rint(bytesPerRow * y + x * numColors);
        switch (numColors) // Does not support CMYK or HSB
        {
            case 1:
                plane[i] = col.r * 255.0;
                break;
            case 2:
                plane[i] = col.r * 255.0;
                plane[i + 1] = col.a * 255.0 ;
                break;
            case 3:
                plane[i] = col.r * 255.0;
                plane[i + 1] = col.g * 255.0 ;
                plane[i + 2] = col.b * 255.0 ;
                break;
            case 4:
                plane[i] = col.r * 255.0;
                plane[i + 1] = col.g * 255.0 ;
                plane[i + 2] = col.b * 255.0 ;
                plane[i + 3] = col.a * 255.0  ;
                break;
           default:
               break;
        }
    }
    else
    {
        i = bytesPerRow * y + x;
        switch (numColors)
        {
            case 1:
                planes[0][i] = col.r * 255.0;
                break;
            default:
                break;
        }
    }
    return;
}

- (struct RGBA) RGBAAtPoint:(NSPoint)point
{
    struct RGBA	color;
    int		i;
    int		numColors = _moreRepFlags.numColors;
    int		bytesPerRow = _bytesPerRow;
    BOOL	isPlanar = _moreRepFlags.isPlanar;
    int     bitsPerPixel = _moreRepFlags.bitsPerPixel;
    unsigned char	*planes[5];
    unsigned char	*plane;
    int			 x, y;
    NSSize		 size;

    memset (&color, 0, sizeof(color));
    size = [self size];
    x = rint (point.x);
    y = rint (size.height - point.y) - 1.0;
    if (x < 0 || x > size.width || y < 0 || y > size.height - 1.0)
        return color;

    color.a = 1;
    
    [self getBitmapDataPlanes:planes];
    
    if (!isPlanar)
    {
        plane = planes[0];
        i = rint(bytesPerRow * y + (x * bitsPerPixel / 8));
        switch (numColors)
        {
            case 1:
                color.r = color.b = color. g = plane[i] / 255.0;
                break;
            case 2:
                color.r = color.b = color. g = plane[i] / 255.0;
                color.a = plane[i + 1] / 255.0;
                break;
            case 3:
                color.r = plane[i] / 255.0;
                color.g = plane[i + 1] / 255.0;
                color.b = plane[i + 2] / 255.0;
                break;
            case 4:
                color.r = plane[i] / 255.0;
                color.g = plane[i + 1] / 255.0;
                color.b = plane[i + 2] / 255.0;
                color.a = plane[i + 3] / 255.0;
                break;
            default:
                break;
        }
    }
    else
    {
        i = bytesPerRow * y + x * bitsPerPixel / (8 * numColors);
//        i = bytesPerRow * y + x;
        switch (numColors)
        {
            case 1:
                color.r = color.g = color.b = planes[0][i] / 255.0;
                break;
            case 2:
                color.r = planes[0][i] / 255.0;
                color.a = planes[1][i] / 255.0;
                break;
            case 3:
                color.r = planes[0][i] / 255.0;
                color.g = planes[1][i] / 255.0;
                color.b = planes[2][i] / 255.0;
                break;
            case 4:
                color.r = planes[0][i] / 255.0;
                color.g = planes[1][i] / 255.0;
                color.b = planes[2][i] / 255.0;
                color.a = planes[3][i] / 255.0;
                break;
            default:
                break;
        }
    }
   
    return color;
}

@end
