/*
	Copyright 1995, Anderson Financial Systems Inc.  All Rights Reserved.
	Anderson Financial Systems, Inc.
	909 Sumneytown Pike, Suite 106
	Springhouse, PA 19477
	215 653 0911
 */

@class StyleParagraphNamed, TableDefinition;
#import "DocumentAccess_Protocol.h"
#import "DocumentFontAccess_Protocol.h"
#import "WUHeaderFooterAccess_Protocol.h"
#import "StyleAccess_Protocol.h"
#import "ParagraphAccess_Protocol.h"
#import "FlowAccess_Protocol.h"
#import "WriteUpSelectionAccess_Protocol.h"

/* used in focusOnFlow to move the insertion point to a flow */
/* 
 * WriteUp has several "flows" of text. The main flow is the "body" of the
 * document. By focusing on a flow, text can be
 * appended, things cut, copy and paste'd etc.  If the flow is WU_NOFLOW,
 * there is no current insertion point.
 */
 
#define WU_HEADER 1
#define WU_FOOTER 2
#define WU_MAINFLOW 0
#define WU_NOFLOW -1

@protocol WriteUpDocumentAccess 

	/* Returns the document's main text flow.
	 */
- (id <FlowAccess>)mainFlowRemote;

	/* Sets up which flow is active.
	 */
- (id <FlowAccess>)focusOnFlow:(int)aFlowIdent; 
 
	/* Returns the document's current flow.
	 */
- (int)currentFlow;
 
	/* Sets the cursor to the beginning of the current flow.
	 */
- (void)beginningOfCurrentFlow;

	/* Sets the cursor to the end of the current flow.
	 */
- (void)endOfCurrentFlow;

	/* Redisplays the current document.  After you have made a number of changes
	 * to a document, you should call recompute to make sure the document view
	 * reflects the changes you made.
	 */
- (void)recompute;

	/* get the current selection in the current flow and returns the filled
 	* selection object.
	 */
- (id <WriteUpSelectionAccess>)getSelection;

	/* set the current selection and selection object in the current flow.
 	 */
- (void)setSelection:(id <WriteUpSelectionAccess> )aSelection;

	/* Saves document to an ASCII file.
	 */
- (BOOL)saveToASCII:(NSString *)pathname;

	/* Saves document to an RTF file.
	 */
- (BOOL)saveToRTF:(NSString *)pathname;

	/* Saves document to an RTFD file.
	 */
- (BOOL)saveToRTFD:(NSString *)pathname;

	/* format should come from AfsDocumentContents object savetypes
	 * This will change the current document format and name.
	 * Currently not fully implemented.
	 */
- (BOOL)saveToFile:(NSString *)pathname documentFormat:(NSString *)format;

	/*  Performs the same operation as selecting the corresponding Menu Item.
	 */
- (void)selectAll;
- (void)setParagraphDefaultFont;
- (void)insertPageBreak;
- (void)insertPageNumber;
- (void)insertTotalPages;
- (void)cutPB;
- (void)pastePB;
- (void)pasteFont;
- (void)pasteRuler;
- (void)copyPB;
- (void)copyFont;
- (void)copyRuler;
- (void)toggleRulers:sender;
- (void)toggleInfoBar:sender;
- (void)showGraphics:sender;
- (void)showGuides:sender;
- (void)alignCenter:sender;
- (void)alignSelJustify:sender;
- (void)alignLeft:sender;
- (void)alignRight:sender;
- (void)changeCase:sender;
- (void)convertSelLowerCase:sender;
- (void)convertSelMixedCase:sender;
- (void)convertSelUpperCase:sender;
- (void)decreasePointSize:sender;
- (void)increasePointSize:sender;
- (void)unscript:sender;
- (void)toggleTextMarkers:sender;

	/* Returns self if found, else nil
	 */
- (int)findString:(NSString *)findString
	replaceWith:(NSString *)replString
	wholeWord:(BOOL)wholeWord
	select:(BOOL)shouldSelect;

	/* Returns self if found, else nil
	 */
- (int)findString:(NSString *)findString
	direction:(int )direction
	fromStart:(BOOL)fromStart
	wholeWord:(BOOL)wholeWord
	select:(BOOL)shouldSelect;

	/* Returns self if found, else nil
	 */
- (int)findString:(NSString *)findString
	select:(BOOL)shouldSelect;

- (void)replaceSelectionWith:(NSString *)replString
	select:(BOOL)shouldSelect;

- (void)findAllStrings:(NSString *)findString
	replaceWith:(NSString *)replString;

	/* DO THIS TO THE CurrentParagraph object instead. As you add paragraphs, 
	 * the style and fonts are carried over. 
	 */
- (void)setFont:(NSString *)fontName size:(float)fontSize;

	/* getfont: returns the name and size of the current font.
	 */
- (NSString *)getFontAndSize:(float *)fontSize;

 /* access the page numbering in the document.
  */
- (int)pagesInDocument;
- (int)firstPageInDocument;
- (void)setFirstPageInDocument:(int)page;

	/* document level style list
	 */
- (int)styleCount;
- (NSString *)styleAtIndex:(int)idx;
- (id <StyleAccess>)styleForName:(NSString *)aName;
- (id <StyleAccess>)createStyleNamed:(NSString *)aName;

	/* COLUMNS
	 */
- (int)numberOfColumnsWithGap:(float *)gapWidth;
- (void)setNumberOfColumns:(int)numCols withGap:(float)gapWidth;


	/* access the margins in the document. these are in POINTS
	 * and are reckoned from the nearest page edge.
	 * So, to get 1 inch margins on top and bottom, but half-inch
	 * margins on the left and right:
	 * float tb = 72.0;
	 * float lr = 36.0;
	 * [doc setMarginsLeft:&lr right:&lr top:&tb bottom:&tb];
	 */
- (void)getMarginsLeft:(float *)left right:(float *)right 
	top:(float *)top bottom:(float *)bottom;
- (void)setMarginsLeft:(float)left right:(float)right 
	top:(float)top bottom:(float)bottom;

@end

