#import "MenuObject.h"

@implementation MenuObject


- (void)applicationDidFinishLaunching:(NSNotification *)notification
// In order for your object to receive this notification make sure that
// your object is a delegate or "File's Owner" in IB.
// Connected from "File's Owner" to AmortControlObject in this case.
{
        // Activate the application
        [NSApp activateIgnoringOtherApps:YES];

        [ProfitWindow center]; // Centers panel on the screen
        [ProfitWindow makeKeyAndOrderFront:NULL];
}

- (void)ShowInfoPanel:(id)sender
{
    if (!InfoPanel)
    {
        // find the bundle in the mainBundle
        Class class;
        NSBundle *bundle;
        NSBundle *mainBundle = [NSBundle mainBundle];

        bundle = [NSBundle bundleWithPath:
            [mainBundle pathForResource:@"InfoPanel" ofType:@"bundle"]];

        // alloc/init and show:
        if (class = [bundle principalClass])
        {
            InfoPanel = [[class alloc] init];
        }
        else
        {
            NSLog(@"Problem loading InfoPanel");
            return;
        }
    }

    [InfoPanel show:nil];
}


- (void)ShowMoreInfo:(id)sender
{
    if (!MoreInfo)
    {
        // find the bundle in the mainBundle
        Class class;
        NSBundle *bundle;
        NSBundle *mainBundle = [NSBundle mainBundle];

        bundle = [NSBundle bundleWithPath:
            [mainBundle pathForResource:@"MoreInfo" ofType:@"bundle"]];

        // alloc/init and show:
        if (class = [bundle principalClass])
        {
            MoreInfo = [[class alloc] init];
        }
        else
        {
            NSLog(@"Problem loading MoreInfo");
            return;
        }
    }

    [MoreInfo show:nil];
}

- (void)HelpandIntro:(id)sender
{
        [NSBundle loadNibNamed:@"HelpIntro.nib" owner:self]; // load nib
}


@end
