/*
    File:       Classroom.m

    Contains:   Source code for Classroom.

    Written by: Laura Rawson

    Created:    7/10/97

    Copyright:  (c)1997 by Apple Computer, Inc., all rights reserved.

    Change History (most recent first):
     Version 1.0d5:  Fixed a potential bug in the set methods of Teacher and Classroom by
                     changing the way the releasing and retaining of objects were being handled. 
     Version 1.0d4:  Recompiled for Rhapsody on PPC.  Added missing dealloc methods.
                     Renamed instance variables to use a more paralell naming convention.
                     Added command key equivalents to Quit and Hide menu items. Changed the
                     implementation of setTeachers and setStudents to work in a cleaner manner.
     Version 1.0d3 : Changed name of nib file to SampleBrowser.nib
     Version 1.0d2 : Added generateTestData to demonstrate a more realistic
                     example of loading a browser. Also fixed a few minor user
                     interface problems.
     Version 1.0d1 : Initial version

    You may incorporate this sample code into your applications without
    restriction, though the sample code has been provided "AS IS" and the
    responsibility for its operation is 100% yours.  However, what you are
    not permitted to do is to redistribute the source as "DSC Sample Code"
    after having made changes. If you're going to re-distribute the source,
    we require that you make it clear in the source that the code was
    descended from Apple Sample Code, but that you've made changes.
*/

#import "Classroom.h"
#import "Browser.h"
#import "Teacher.h"

@implementation Classroom

- (void)dealloc
{
    [teacherArray release];
    [grade release];
    [super dealloc];
}

- (void)setGrade:(NSString*)classGrade
{
    [grade autorelease];
    grade = [classGrade copyWithZone:[self zone]];
}

- (void)setTeachers:(NSArray*)teacherList
{
    [teacherArray autorelease];
    teacherArray = [teacherList copyWithZone:[self zone]];
}

- (NSString*)grade
{
    return grade;
}

- (NSArray*)teachers
{
    return teacherArray;
}


@end
