// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OAAppkitQueueProcessor.h"

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

RCS_ID("$Header: /Network/Developer/Source/CVS/OmniGroup/OmniAppKit/OAAppkitQueueProcessor.m,v 1.8 1998/12/08 04:06:19 kc Exp $")

@interface OAAppkitQueueProcessor : OFRunLoopQueueProcessor
{
}
    
@end

@implementation OAAppkitQueueProcessor

// Give UI events priority over queued messages

- (BOOL)shouldProcessQueueEnd;
{
    OmniFoundation_EXTERN BOOL OFQueueProcessorDebug;
    NSEvent *event;

    [[NSThread currentThread] yield];
    event = [NSApp nextEventMatchingMask:NSAnyEventMask untilDate:[NSDate distantPast] inMode:NSEventTrackingRunLoopMode dequeue:NO];
    if (event) {
	if (OFQueueProcessorDebug)
	    NSLog(@"%@: breaking for event: %@", OBShortObjectDescription(self), event);
	return YES;
    }
    return NO;
}

@end

static OAAppkitQueueProcessor *appkitQueueProcessor = nil;

@implementation OFQueueProcessor (AppkitQueueProcessor)

+ (OFQueueProcessor *)appkitQueueProcessor;
{
    if (!appkitQueueProcessor)
        appkitQueueProcessor = [[OAAppkitQueueProcessor alloc] initForQueue:[OFMessageQueue mainQueue]];
    return appkitQueueProcessor;
}

+ (void)startAppkitQueueProcessor;
{
    NSArray *modes;
    
    if (![NSThread inMainThread])
        [NSException raise:@"OmniAppKitWrongThread" format:@"Attempted to start an OAAppkitQueueProcessor from a thread other than the main thread"];

    modes = [[NSArray alloc] initWithObjects:NSDefaultRunLoopMode, NSModalPanelRunLoopMode, nil];
    [(OAAppkitQueueProcessor *)[self appkitQueueProcessor] runFromCurrentRunLoopInModes:modes];
    [modes release];
}

+ (void)disableAppkitQueueEventProcessing;
{
    [(OAAppkitQueueProcessor *)[self appkitQueueProcessor] disable];
}

+ (void)reenableAppkitQueueEventProcessing;
{
    [(OAAppkitQueueProcessor *)[self appkitQueueProcessor] enable];
}

@end
