// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "NSScrollView-OAExtensions.h"

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

RCS_ID("$Header: /Network/Developer/Source/CVS/OmniGroup/OmniAppKit/OpenStepExtensions.subproj/NSScrollView-OAExtensions.m,v 1.3 1998/12/08 04:06:48 kc Exp $")

@implementation NSScrollView (OAExtensions)

- (void)freeGStates;
{
    [self releaseGState];
    [[self contentView] releaseGState];
}

/* Overrides of View extensions */

- (void)scrollDownByPercentage:(float)percentage;
{
    [[self documentView] scrollDownByPercentage:percentage];
}

- (float)fraction;
{
    return [[self documentView] fraction];
}

- (void)setFraction:(float)newFract;
{
    [[self documentView] setFraction:newFract];
}


// OAStatusViewPosition protocol

- (NSPoint)upperRightCornerForStatusDisplayer:(OAStatusDisplayer *)statusDisplayer shouldDrawInView:(NSView **)view;
{
    NSRect clipViewFrame;
    NSPoint upperRightCorner;

    clipViewFrame = [[self contentView] frame];
    upperRightCorner = (NSPoint){NSMaxX(clipViewFrame), [self isFlipped] ? NSMinY(clipViewFrame) : NSMaxY(clipViewFrame)};

    *view = self;
    return upperRightCorner;
}

@end
