// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OAFontView.h"

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

#import "NSString-OAExtensions.h"
#import "ps.h"

RCS_ID("$Header: /Network/Developer/Source/CVS/OmniGroup/OmniAppKit/Widgets.subproj/OAFontView.m,v 1.7 1998/12/08 04:07:19 kc Exp $")

@implementation OAFontView

// Init and dealloc

- initWithFrame:(NSRect)frameRect
{
    if (![super initWithFrame:frameRect])
        return nil;

    [self setFont:[NSFont userFontOfSize:0]];

    return self;
}

- (void)dealloc;
{
    [font release];
    [fontDescription release];
    [super dealloc];
}

//

- (NSFont *)font;
{
    return font;
}

- (void)setFont:(NSFont *)newFont;
{
    if (font == newFont)
	return;

    [font release];
    font = [newFont retain];

    [fontDescription release];
    fontDescription = [[NSString alloc] initWithFormat:@"%@ %.1f", [font displayName], [font pointSize]];
    textSize.height = ceil(NSHeight([font boundingRectForFont]));
    textSize.width = ceil([font widthOfString:fontDescription]);
    [self setNeedsDisplay:YES];
}

- (IBAction)setFontUsingFontPanel:(id)sender;
{
    if ([[self window] makeFirstResponder:self])
	[[NSFontManager new] orderFrontFontPanel:sender];
}

// NSFontManager sends -changeFont: up the responder chain

- (void)changeFont:(id)sender;
{
    [self setFont:[sender convertFont:[sender selectedFont]]];
    [delegate fontView:self didChangeToFont:font];
}

// NSView subclass

- (void)drawRect:(NSRect)rect
{
    NSRect bounds;

    if ([[self window] firstResponder] == self)
	[[NSColor textBackgroundColor] set];
    else
	[[NSColor controlColor] set];

    bounds = [self bounds];
    NSRectFill(bounds);

    [fontDescription drawWithFont:font color:[NSColor textColor] alignment:NSCenterTextAlignment rectangle:bounds];
}

- (BOOL)isFlipped;
{
    return YES;
}

- (BOOL)isOpaque;
{
    return YES;
}

// NSResponder subclass

- (BOOL)acceptsFirstResponder;
{
    return YES;
}

- (BOOL)becomeFirstResponder;
{
    if ([super becomeFirstResponder]) {
	[[NSFontManager new] setSelectedFont:font isMultiple:NO];
	[self display];
	return YES;
    }
    return NO;
}

- (BOOL)resignFirstResponder;
{
    if (![[self window] isKeyWindow] ||
	![super resignFirstResponder])
	return NO;
    [self setNeedsDisplay:YES];
    return YES;
}

// Debugging

- (NSMutableDictionary *)debugDictionary;
{
    NSMutableDictionary *debugDictionary;

    debugDictionary = [super debugDictionary];
    if (font)
        [debugDictionary setObject:font forKey:@"font"];
    if (fontDescription)
        [debugDictionary setObject:fontDescription forKey:@"fontDescription"];
    [debugDictionary setObject:NSStringFromSize(textSize) forKey:@"textSize"];
    return debugDictionary;
}

@end
