// Copyright 1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OATextField.h"

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

RCS_ID("$Header: /Network/Developer/Source/CVS/OmniGroup/OmniAppKit/Widgets.subproj/OATextField.m,v 1.2 1998/12/08 04:07:31 kc Exp $")

@interface OATextField (PrivateAPI)
- (void) _updateLabel;
@end

@implementation OATextField

- initWithCoder: (NSCoder *) coder;
{
    if (!(self = [super initWithCoder: coder]))
        return nil;

    // we don't currently archive the label field since this object isn't palettized.
    // rather, IB encodes a connector and manually sets the ivar
    //label = [[coder decodeObject] retain];
    [self _updateLabel];

    return self;
}

- (void) setEditable: (BOOL) isEditable;
{
    [super setEditable: isEditable];
    [self _updateLabel];
}

- (void) setEnabled: (BOOL) isEnabled;
{
    [super setEnabled: isEnabled];
    [self _updateLabel];
}

@end


@implementation OATextField (PrivateAPI)

- (void) _updateLabel;
{
    NSColor *color;

    if ([self isEnabled] && [self isEditable])
        color = [NSColor controlTextColor];
    else
        color = [NSColor disabledControlTextColor];

    [label setTextColor: color];
}

@end
