/* Copyright Abandoned 1996 TCX DataKonsult AB & Monty Program KB & Detron HB
   This file is public domain and comes with NO WARRANTY of any kind */

/* For use with thr_lock:s */

#ifndef _thr_lock_h
#define _thr_lock_h
#ifdef	__cplusplus
extern "C" {
#endif

#include <my_pthread.h>
#include <my_list.h>

struct st_thr_lock;

enum thr_lock_type { TL_IGNORE=-1,
		     TL_UNLOCK, TL_READ,  TL_READ_HIGH_PRIORITY,
		     TL_READ_NO_INSERT,
		     TL_WRITE_ALLOW_WRITE, TL_WRITE_ALLOW_READ,
		     TL_WRITE_CONCURRENT_INSERT,
		     TL_WRITE_DELAYED, TL_WRITE_LOW_PRIORITY, TL_WRITE,
		     TL_WRITE_ONLY};

extern ulong max_write_lock_count;
extern my_bool thr_lock_inited;

typedef struct st_thr_lock_data {
  pthread_t thread;
  struct st_thr_lock_data *next,**prev;
  struct st_thr_lock *lock;
  pthread_cond_t *cond;
  enum thr_lock_type type;
  ulong thread_id;
  void *status_param;			/* Param to status functions */
} THR_LOCK_DATA;

struct st_lock_list {
  THR_LOCK_DATA *data,**last;
};

typedef struct st_thr_lock {
  LIST list;
  pthread_mutex_t mutex;
  struct st_lock_list read_wait;
  struct st_lock_list read;
  struct st_lock_list write_wait;
  struct st_lock_list write;
/* write_lock_count is incremented for write locks and reset on read locks */
  ulong write_lock_count;
  uint read_no_write_count;
  void (*get_status)(void*);		/* When one gets a lock */
  void (*copy_status)(void*,void*);
  void (*update_status)(void*);		/* Before release of write */
  my_bool (*check_status)(void *);
} THR_LOCK;


my_bool init_thr_lock(void);		/* Must be called once/thread */
void thr_lock_init(THR_LOCK *lock);
void thr_lock_delete(THR_LOCK *lock);
void thr_lock_data_init(THR_LOCK *lock,THR_LOCK_DATA *data,
			void *status_param);
int thr_lock(THR_LOCK_DATA *data,enum thr_lock_type lock_type);
void thr_unlock(THR_LOCK_DATA *data);
int thr_multi_lock(THR_LOCK_DATA **data,uint count);
void thr_multi_unlock(THR_LOCK_DATA **data,uint count);
void thr_abort_locks(THR_LOCK *lock);
void thr_print_locks(void);		/* For debugging */
my_bool thr_upgrade_write_delay_lock(THR_LOCK_DATA *data);
my_bool thr_reschedule_write_lock(THR_LOCK_DATA *data);
#ifdef	__cplusplus
}
#endif
#endif /* _thr_lock_h */
