/*

 MiscSoundTrackerInspector
 Version 2.0
 Copyright (c) 1995 by Sean Luke
 OpenStep / Rhapsody port
 Copyright (c) 1998 by Jerome Genest
 Donated to the MiscKit

 Permission to use, copy, modify, and distribute this material
 for any purpose and without fee, under the restrictions as noted
 in the MiscKit copyright notice, is hereby granted, provided that
 the MiscKit copyright notice and this permission notice
 appear in all source copies, and that the authors names shall not
 be used in advertising or publicity pertaining to this
 material without the specific, prior written permission
 of the author.  SEAN O. LUKE AMD JEROME GENEST  MAKE NO REPRESENTATIONS
 ABOUT THE ACCURACY OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.
 IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES.

 */

#import <MiscSoundKit/MiscSoundTracker.h>
#import "MiscSoundTrackerInspector.h"

@implementation MiscSoundTrackerInspector

- init
	{
	NSString* buf;
	id bundle;
	[super init];

	bundle=[NSBundle bundleForClass:[self class]];
	buf = [bundle pathForResource:@"MiscSoundTrackerInspector" ofType:@"nib"];
	[NSBundle loadNibFile:buf externalNameTable:[NSDictionary dictionaryWithObjectsAndKeys:self, @"NSOwner", nil] withZone:[self zone]];
	return self;
	}
	

- (void) ok:sender
	{
	id object = [self object];
	float r=[refresh floatValue];
	float s=[sampling floatValue];
	if (r<=0){r=SOUNDTRACKER_TIMED_ENTRY_SPEED;[refresh setFloatValue:r];}
	if (s<=0){s=SOUNDTRACKER_DEFAULT_SAMPLING_RATE;[sampling setFloatValue:s];}
	
	[object setSendType:[matrix selectedRow]+1];
	[object setRefresh:r];
	[object setDefaultSamplingRate:s];
	
	return [super ok:sender];
	}


- (void) revert:sender
	{
	id object = [self object];

	[matrix selectCellAtRow:[object sendType]-1 column:0];
	[refresh setFloatValue:[object refresh]];
	[sampling setFloatValue:[object defaultSamplingRate]];

	return [super revert:sender];
	}
	
- (BOOL) wantsButtons
	{
	return NO;
	}

@end
