#import "Converter.h"

static NSImage * sharedImage;

@implementation Converter

- (void)temperatureChanged:(id)sender
{
    int celsius;
    float fahrenheit;

    celsius = [sender intValue];
    [celsiusTextField setIntValue:celsius];
    fahrenheit = 1.8 * celsius + 32.0;
    [fahrenheitTextField setIntValue:fahrenheit];
}

- (void)encodeWithCoder:(NSCoder *)aCoder
{
  [aCoder encodeConditionalObject:celsiusTextField];
  [aCoder encodeConditionalObject:fahrenheitTextField];

}

- (id)initWithCoder:(NSCoder *)aDecoder
{
  if (self = [super init])
  {
    celsiusTextField = [aDecoder decodeObject];
    fahrenheitTextField = [aDecoder decodeObject];
  }
  return self;
}

- (NSImage *)imageForViewer
{
        NSString *path;

        if (!sharedImage)
        {
                path = [[NSBundle bundleForClass:[self class]]
                                pathForResource:@"Converter" ofType:@"tiff"];
                sharedImage = [[NSImage alloc] initWithContentsOfFile:path];
        }
        return sharedImage;
}

@end
