/* StopWatch.m
 *
 * You may freely copy, distribute and reuse the code in this example.
 * Apple Computer, Inc. disclaims any warranty of any kind, expressed or implied, as to
 * its fitness for any particular use.
 */

#import "StopWatch.h"

@implementation StopWatch

- (void)start:(id)sender
{
	NSCalendarDate *now = [[[NSCalendarDate alloc] init] autorelease];
	[self setStartTime:now];
	[self setStopTime:nil];
	[sender setAction:@selector(stop:)];
	[sender setTitle:@"Stop"];
	[startField setObjectValue:[self startTime]];
	[secondsField setStringValue:@""];
	[stopField setStringValue:@""];
}

- (void)stop:(id)sender
{
	int duration;
	
	[self setStopTime:[NSCalendarDate calendarDate]];
	[sender setAction:@selector(start:)];
	[sender setTitle:@"Start"];
	[stopField setObjectValue:[self stopTime]];
	duration = [[self stopTime] timeIntervalSinceDate: [self startTime]];
	[secondsField setIntValue:duration];
}

- (void)setStartTime:(NSCalendarDate *)aDate
{
        [startTime autorelease];
        startTime = [aDate retain];
}
- (NSCalendarDate *)startTime
{
        return startTime;
}
- (void)setStopTime:(NSCalendarDate *)aDate
{
        [stopTime autorelease];
        stopTime = [aDate retain];
}
- (NSCalendarDate *)stopTime
{
        return stopTime;
}
@end
